/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperationRequest;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskResult;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.util.distributed.DistributedProcess;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class SnapshotRestoreProcess {
    public static final String TMP_CACHE_DIR_PREFIX = "_tmp_snp_restore_";
    private static final String OP_REJECT_MSG = "Cache group restore operation was rejected. ";
    private final GridKernalContext ctx;
    private final DistributedProcess<SnapshotOperationRequest, ArrayList<StoredCacheData>> prepareRestoreProc;
    private final DistributedProcess<UUID, Boolean> cacheStartProc;
    private final DistributedProcess<UUID, Boolean> rollbackRestoreProc;
    private final IgniteLogger log;
    private volatile IgniteSnapshotManager.ClusterSnapshotFuture fut;
    private volatile SnapshotRestoreContext opCtx;

    public SnapshotRestoreProcess(GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(this.getClass());
        this.prepareRestoreProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.RESTORE_CACHE_GROUP_SNAPSHOT_PREPARE, this::prepare, this::finishPrepare);
        this.cacheStartProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.RESTORE_CACHE_GROUP_SNAPSHOT_START, this::cacheStart, this::finishCacheStart);
        this.rollbackRestoreProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.RESTORE_CACHE_GROUP_SNAPSHOT_ROLLBACK, this::rollback, this::finishRollback);
    }

    protected void cleanup() throws IgniteCheckedException {
        FilePageStoreManager pageStore = (FilePageStoreManager)this.ctx.cache().context().pageStore();
        File dbDir = pageStore.workDir();
        for (File dir2 : dbDir.listFiles(dir -> dir.isDirectory() && dir.getName().startsWith(TMP_CACHE_DIR_PREFIX))) {
            if (U.delete(dir2)) continue;
            throw new IgniteCheckedException("Unable to remove temporary directory, try deleting it manually [dir=" + dir2 + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteFuture<Void> start(String snpName, @Nullable Collection<String> cacheGrpNames) {
        IgniteSnapshotManager.ClusterSnapshotFuture fut0;
        try {
            if (this.ctx.clientNode()) {
                throw new IgniteException("Cache group restore operation was rejected. Client and daemon nodes can not perform this operation.");
            }
            DiscoveryDataClusterState clusterState = this.ctx.state().clusterState();
            if (clusterState.state() != ClusterState.ACTIVE || clusterState.transition()) {
                throw new IgniteException("Cache group restore operation was rejected. The cluster should be active.");
            }
            if (!clusterState.hasBaselineTopology()) {
                throw new IgniteException("Cache group restore operation was rejected. The baseline topology is not configured for cluster.");
            }
            if (!IgniteFeatures.allNodesSupports(this.ctx.grid().cluster().nodes(), IgniteFeatures.SNAPSHOT_RESTORE_CACHE_GROUP)) {
                throw new IgniteException("Cache group restore operation was rejected. Not all nodes in the cluster support restore operation.");
            }
            if (this.ctx.cache().context().snapshotMgr().isSnapshotCreating()) {
                throw new IgniteException("Cache group restore operation was rejected. A cluster snapshot operation is in progress.");
            }
            SnapshotRestoreProcess snapshotRestoreProcess = this;
            synchronized (snapshotRestoreProcess) {
                if (this.restoringSnapshotName() != null) {
                    throw new IgniteException("Cache group restore operation was rejected. The previous snapshot restore operation was not completed.");
                }
                fut0 = this.fut = new IgniteSnapshotManager.ClusterSnapshotFuture(UUID.randomUUID(), snpName);
            }
        }
        catch (IgniteException e) {
            return new IgniteFinishedFutureImpl<Void>(e);
        }
        this.ctx.cache().context().snapshotMgr().checkSnapshot(snpName, cacheGrpNames).listen(f -> {
            if (f.error() != null) {
                this.finishProcess(fut0.rqId, f.error());
                return;
            }
            if (!F.isEmpty(((SnapshotPartitionsVerifyTaskResult)f.result()).exceptions())) {
                this.finishProcess(fut0.rqId, F.first(((SnapshotPartitionsVerifyTaskResult)f.result()).exceptions().values()));
                return;
            }
            if (fut0.interruptEx != null) {
                this.finishProcess(fut0.rqId, fut0.interruptEx);
                return;
            }
            HashSet<UUID> dataNodes = new HashSet<UUID>();
            HashSet<String> snpBltNodes = null;
            Map<ClusterNode, List<SnapshotMetadata>> metas = ((SnapshotPartitionsVerifyTaskResult)f.result()).metas();
            Map reqGrpIds = cacheGrpNames == null ? Collections.emptyMap() : cacheGrpNames.stream().collect(Collectors.toMap(GridCacheUtils::cacheId, v -> v));
            for (Map.Entry<ClusterNode, List<SnapshotMetadata>> entry : metas.entrySet()) {
                SnapshotMetadata meta = F.first(entry.getValue());
                assert (meta != null) : entry.getKey().id();
                if (!entry.getKey().consistentId().toString().equals(meta.consistentId())) continue;
                if (snpBltNodes == null) {
                    snpBltNodes = new HashSet<String>(meta.baselineNodes());
                }
                dataNodes.add(entry.getKey().id());
                reqGrpIds.keySet().removeAll(meta.partitions().keySet());
            }
            if (snpBltNodes == null) {
                this.finishProcess(fut0.rqId, new IllegalArgumentException("Cache group restore operation was rejected. No snapshot data has been found [groups=" + reqGrpIds.values() + ", snapshot=" + snpName + ']'));
                return;
            }
            if (!reqGrpIds.isEmpty()) {
                this.finishProcess(fut0.rqId, new IllegalArgumentException("Cache group restore operation was rejected. Cache group(s) was not found in the snapshot [groups=" + reqGrpIds.values() + ", snapshot=" + snpName + ']'));
                return;
            }
            Collection<String> bltNodes = F.viewReadOnly(this.ctx.discovery().serverNodes(AffinityTopologyVersion.NONE), node -> node.consistentId().toString(), node -> CU.baselineNode(node, this.ctx.state().clusterState()));
            snpBltNodes.removeAll(bltNodes);
            if (!snpBltNodes.isEmpty()) {
                this.finishProcess(fut0.rqId, new IgniteIllegalStateException("Cache group restore operation was rejected. Some nodes required to restore a cache group are missing [nodeId(s)=" + snpBltNodes + ", snapshot=" + snpName + ']'));
                return;
            }
            IdleVerifyResultV2 res = ((SnapshotPartitionsVerifyTaskResult)f.result()).idleVerifyResult();
            if (!F.isEmpty(res.exceptions()) || res.hasConflicts()) {
                StringBuilder sb = new StringBuilder();
                res.print(sb::append, true);
                this.finishProcess(fut0.rqId, new IgniteException(sb.toString()));
                return;
            }
            SnapshotOperationRequest req = new SnapshotOperationRequest(fut0.rqId, (UUID)F.first(dataNodes), snpName, cacheGrpNames, dataNodes);
            this.prepareRestoreProc.start(req.requestId(), req);
        });
        return new IgniteFutureImpl<Void>(fut0);
    }

    @Nullable
    public String restoringSnapshotName() {
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 != null) {
            return opCtx0.snpName;
        }
        IgniteSnapshotManager.ClusterSnapshotFuture fut0 = this.fut;
        return fut0 != null ? fut0.name : null;
    }

    public boolean isRestoring(String cacheName, @Nullable String grpName) {
        int cacheId;
        assert (cacheName != null);
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 == null) {
            return false;
        }
        Map cacheCfgs = opCtx0.cfgs;
        if (cacheCfgs.containsKey(cacheId = CU.cacheId(cacheName))) {
            return true;
        }
        for (File grpDir : opCtx0.dirs) {
            String locGrpName = FilePageStoreManager.cacheGroupName(grpDir);
            if (grpName != null) {
                if (cacheName.equals(locGrpName)) {
                    return true;
                }
                if (CU.cacheId(locGrpName) != CU.cacheId(grpName)) continue;
                return true;
            }
            if (CU.cacheId(locGrpName) != cacheId) continue;
            return true;
        }
        return false;
    }

    public Set<UUID> cacheStartRequiredAliveNodes(IgniteUuid reqId) {
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 == null || !reqId.globalId().equals(opCtx0.reqId)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(opCtx0.nodes);
    }

    private void finishProcess(UUID reqId) {
        this.finishProcess(reqId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishProcess(UUID reqId, @Nullable Throwable err) {
        if (err != null) {
            this.log.error("Failed to restore snapshot cache group [reqId=" + reqId + ']', err);
        } else if (this.log.isInfoEnabled()) {
            this.log.info("Successfully restored cache group(s) from the snapshot [reqId=" + reqId + ']');
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 != null && reqId.equals(opCtx0.reqId)) {
            this.opCtx = null;
        }
        SnapshotRestoreProcess snapshotRestoreProcess = this;
        synchronized (snapshotRestoreProcess) {
            IgniteSnapshotManager.ClusterSnapshotFuture fut0 = this.fut;
            if (fut0 != null && reqId.equals(fut0.rqId)) {
                this.fut = null;
                this.ctx.getSystemExecutorService().submit(() -> fut0.onDone(null, err));
            }
        }
    }

    public void onNodeLeft(UUID leftNodeId) {
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 != null && opCtx0.nodes.contains(leftNodeId)) {
            opCtx0.err.compareAndSet(null, new ClusterTopologyCheckedException("Cache group restore operation was rejected. Required node has left the cluster [nodeId=" + leftNodeId + ']'));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteFuture<Boolean> cancel(IgniteCheckedException reason, String snpName) {
        boolean ctxStop;
        SnapshotRestoreContext opCtx0;
        IgniteSnapshotManager.ClusterSnapshotFuture fut0 = null;
        SnapshotRestoreProcess snapshotRestoreProcess = this;
        synchronized (snapshotRestoreProcess) {
            opCtx0 = this.opCtx;
            if (this.fut != null && this.fut.name.equals(snpName)) {
                fut0 = this.fut;
                fut0.interruptEx = reason;
            }
        }
        boolean bl = ctxStop = opCtx0 != null && opCtx0.snpName.equals(snpName);
        if (ctxStop) {
            this.interrupt(opCtx0, reason);
        }
        return fut0 == null ? new IgniteFinishedFutureImpl<Boolean>(ctxStop) : new IgniteFutureImpl<Boolean>(fut0.chain(f -> true));
    }

    public void interrupt(IgniteCheckedException reason) {
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 != null) {
            this.interrupt(opCtx0, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interrupt(SnapshotRestoreContext opCtx, IgniteCheckedException reason) {
        IgniteFuture stopFut;
        opCtx.err.compareAndSet(null, reason);
        SnapshotRestoreProcess snapshotRestoreProcess = this;
        synchronized (snapshotRestoreProcess) {
            stopFut = opCtx.stopFut;
        }
        if (stopFut != null) {
            stopFut.get();
        }
    }

    private void ensureCacheAbsent(String name) {
        int id = CU.cacheId(name);
        if (this.ctx.cache().cacheGroupDescriptors().containsKey(id) || this.ctx.cache().cacheDescriptor(id) != null) {
            throw new IgniteIllegalStateException("Cache \"" + name + "\" should be destroyed manually before perform restore operation.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<ArrayList<StoredCacheData>> prepare(SnapshotOperationRequest req) {
        if (this.ctx.clientNode()) {
            return new GridFinishedFuture<ArrayList<StoredCacheData>>();
        }
        try {
            DiscoveryDataClusterState state = this.ctx.state().clusterState();
            if (state.state() != ClusterState.ACTIVE || state.transition()) {
                throw new IgniteCheckedException("Cache group restore operation was rejected. The cluster should be active.");
            }
            if (this.ctx.cache().context().snapshotMgr().isSnapshotCreating()) {
                throw new IgniteCheckedException("Cache group restore operation was rejected. A cluster snapshot operation is in progress.");
            }
            for (UUID uUID : req.nodes()) {
                ClusterNode node = this.ctx.discovery().node(uUID);
                if (node != null && CU.baselineNode(node, state) && this.ctx.discovery().alive(node)) continue;
                throw new IgniteCheckedException("Cache group restore operation was rejected. Required node has left the cluster [nodeId-" + uUID + ']');
            }
            SnapshotRestoreContext opCtx0 = this.prepareContext(req);
            SnapshotRestoreProcess snapshotRestoreProcess = this;
            synchronized (snapshotRestoreProcess) {
                this.opCtx = opCtx0;
                IgniteSnapshotManager.ClusterSnapshotFuture fut0 = this.fut;
                if (fut0 != null && fut0.interruptEx != null) {
                    opCtx0.err.compareAndSet(null, fut0.interruptEx);
                }
            }
            if (opCtx0.dirs.isEmpty()) {
                return new GridFinishedFuture<ArrayList<StoredCacheData>>();
            }
            for (StoredCacheData cfg : opCtx0.cfgs.values()) {
                this.ensureCacheAbsent(cfg.config().getName());
                if (F.isEmpty(cfg.config().getGroupName())) continue;
                this.ensureCacheAbsent(cfg.config().getGroupName());
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting local snapshot restore operation [reqId=" + req.requestId() + ", snapshot=" + req.snapshotName() + ", cache(s)=" + F.viewReadOnly(opCtx0.cfgs.values(), data -> data.config().getName(), new IgnitePredicate[0]) + ']');
            }
            Consumer<Throwable> consumer = ex -> this.opCtx.err.compareAndSet(null, ex);
            BooleanSupplier stopChecker = () -> this.opCtx.err.get() != null;
            GridFutureAdapter<ArrayList<StoredCacheData>> retFut = new GridFutureAdapter<ArrayList<StoredCacheData>>();
            if (this.ctx.isStopping()) {
                throw new NodeStoppingException("Node is stopping.");
            }
            opCtx0.stopFut = new IgniteFutureImpl<Object>(retFut.chain(f -> null));
            this.restoreAsync(opCtx0.snpName, opCtx0.dirs, this.ctx.localNodeId().equals(req.operationalNodeId()), stopChecker, consumer).thenAccept(res -> {
                try {
                    Throwable err = (Throwable)this.opCtx.err.get();
                    if (err != null) {
                        throw err;
                    }
                    for (File src : opCtx0.dirs) {
                        Files.move(this.formatTmpDirName(src).toPath(), src.toPath(), StandardCopyOption.ATOMIC_MOVE);
                    }
                }
                catch (Throwable t) {
                    this.log.error("Unable to restore cache group(s) from the snapshot [reqId=" + this.opCtx.reqId + ", snapshot=" + this.opCtx.snpName + ']', t);
                    retFut.onDone(t);
                    return;
                }
                retFut.onDone(new ArrayList(this.opCtx.cfgs.values()));
            });
            return retFut;
        }
        catch (RejectedExecutionException | IgniteCheckedException | IgniteIllegalStateException e) {
            this.log.error("Unable to restore cache group(s) from the snapshot [reqId=" + req.requestId() + ", snapshot=" + req.snapshotName() + ']', e);
            return new GridFinishedFuture<ArrayList<StoredCacheData>>(e);
        }
    }

    private File formatTmpDirName(File cacheDir) {
        return new File(cacheDir.getParent(), TMP_CACHE_DIR_PREFIX + cacheDir.getName());
    }

    private CompletableFuture<Void> restoreAsync(String snpName, Collection<File> dirs, boolean updateMeta, BooleanSupplier stopChecker, Consumer<Throwable> errHnd) throws IgniteCheckedException {
        IgniteSnapshotManager snapshotMgr = this.ctx.cache().context().snapshotMgr();
        String pdsFolderName = this.ctx.pdsFolderResolver().resolveFolders().folderName();
        ArrayList<CompletableFuture<Void>> futs = new ArrayList<CompletableFuture<Void>>();
        if (updateMeta) {
            File binDir = CacheObjectBinaryProcessorImpl.binaryWorkDir(snapshotMgr.snapshotLocalDir(snpName).getAbsolutePath(), pdsFolderName);
            futs.add(CompletableFuture.runAsync(() -> {
                try {
                    this.ctx.cacheObjects().updateMetadata(binDir, stopChecker);
                }
                catch (Throwable t) {
                    errHnd.accept(t);
                }
            }, snapshotMgr.snapshotExecutorService()));
        }
        for (File cacheDir : dirs) {
            File tmpCacheDir = this.formatTmpDirName(cacheDir);
            File snpCacheDir = new File(this.ctx.cache().context().snapshotMgr().snapshotLocalDir(snpName), Paths.get(IgniteSnapshotManager.databaseRelativePath(pdsFolderName), cacheDir.getName()).toString());
            assert (snpCacheDir.exists()) : "node=" + this.ctx.localNodeId() + ", dir=" + snpCacheDir;
            for (File snpFile : snpCacheDir.listFiles()) {
                futs.add(CompletableFuture.runAsync(() -> {
                    if (stopChecker.getAsBoolean()) {
                        return;
                    }
                    try {
                        if (Thread.interrupted()) {
                            throw new IgniteInterruptedCheckedException("Thread has been interrupted.");
                        }
                        File target = new File(tmpCacheDir, snpFile.getName());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Copying file from the snapshot [snapshot=" + snpName + ", src=" + snpFile + ", target=" + target + "]");
                        }
                        IgniteSnapshotManager.copy(snapshotMgr.ioFactory(), snpFile, target, snpFile.length());
                    }
                    catch (Throwable t) {
                        errHnd.accept(t);
                    }
                }, this.ctx.cache().context().snapshotMgr().snapshotExecutorService()));
            }
        }
        int futsSize = futs.size();
        return CompletableFuture.allOf(futs.toArray(new CompletableFuture[futsSize]));
    }

    private SnapshotRestoreContext prepareContext(SnapshotOperationRequest req) throws IgniteCheckedException {
        if (this.opCtx != null) {
            throw new IgniteCheckedException("Cache group restore operation was rejected. The previous snapshot restore operation was not completed.");
        }
        GridCacheSharedContext cctx = this.ctx.cache().context();
        SnapshotMetadata meta = F.first(cctx.snapshotMgr().readSnapshotMetadatas(req.snapshotName()));
        if (meta == null || !meta.consistentId().equals(cctx.localNode().consistentId().toString())) {
            return new SnapshotRestoreContext(req, Collections.emptyList(), Collections.emptyMap());
        }
        if (meta.pageSize() != cctx.database().pageSize()) {
            throw new IgniteCheckedException("Incompatible memory page size [snapshotPageSize=" + meta.pageSize() + ", local=" + cctx.database().pageSize() + ", snapshot=" + req.snapshotName() + ", nodeId=" + cctx.localNodeId() + ']');
        }
        ArrayList<File> cacheDirs = new ArrayList<File>();
        HashMap<String, StoredCacheData> cfgsByName = new HashMap<String, StoredCacheData>();
        FilePageStoreManager pageStore = (FilePageStoreManager)cctx.pageStore();
        for (File snpCacheDir : cctx.snapshotMgr().snapshotCacheDirectories(req.snapshotName(), meta.folderName(), name -> !"MetaStorage".equals(name))) {
            File tmpCacheDir;
            String grpName = FilePageStoreManager.cacheGroupName(snpCacheDir);
            if (!F.isEmpty(req.groups()) && !req.groups().contains(grpName)) continue;
            File cacheDir = pageStore.cacheWorkDir(snpCacheDir.getName().startsWith("cacheGroup-"), grpName);
            if (cacheDir.exists()) {
                if (!cacheDir.isDirectory()) {
                    throw new IgniteCheckedException("Unable to restore cache group, file with required directory name already exists [group=" + grpName + ", file=" + cacheDir + ']');
                }
                if (cacheDir.list().length > 0) {
                    throw new IgniteCheckedException("Unable to restore cache group, directory is not empty [group=" + grpName + ", dir=" + cacheDir + ']');
                }
                if (!cacheDir.delete()) {
                    throw new IgniteCheckedException("Unable to remove empty cache directory [group=" + grpName + ", dir=" + cacheDir + ']');
                }
            }
            if ((tmpCacheDir = this.formatTmpDirName(cacheDir)).exists()) {
                throw new IgniteCheckedException("Unable to restore cache group, temp directory already exists [group=" + grpName + ", dir=" + tmpCacheDir + ']');
            }
            if (!tmpCacheDir.mkdir()) {
                throw new IgniteCheckedException("Unable to restore cache group, cannot create temp directory [group=" + grpName + ", dir=" + tmpCacheDir + ']');
            }
            cacheDirs.add(cacheDir);
            pageStore.readCacheConfigurations(snpCacheDir, cfgsByName);
        }
        Map<Integer, StoredCacheData> cfgsById = cfgsByName.values().stream().collect(Collectors.toMap(v -> CU.cacheId(v.config().getName()), v -> v));
        return new SnapshotRestoreContext(req, cacheDirs, cfgsById);
    }

    private void finishPrepare(UUID reqId, Map<UUID, ArrayList<StoredCacheData>> res, Map<UUID, Exception> errs) {
        if (this.ctx.clientNode()) {
            return;
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        Exception failure = F.first(errs.values());
        assert (opCtx0 != null || failure != null) : "Context has not been created on the node " + this.ctx.localNodeId();
        if (opCtx0 == null || !reqId.equals(opCtx0.reqId)) {
            this.finishProcess(reqId, failure);
            return;
        }
        if (failure == null) {
            failure = this.checkNodeLeft(opCtx0.nodes, res.keySet());
        }
        if (failure != null) {
            opCtx0.err.compareAndSet(null, failure);
            if (U.isLocalNodeCoordinator(this.ctx.discovery())) {
                this.rollbackRestoreProc.start(reqId, reqId);
            }
            return;
        }
        HashMap<Integer, StoredCacheData> globalCfgs = new HashMap<Integer, StoredCacheData>();
        for (List list : res.values()) {
            if (list == null) continue;
            for (StoredCacheData cacheData : list) {
                globalCfgs.put(CU.cacheId(cacheData.config().getName()), cacheData);
            }
        }
        opCtx0.cfgs = globalCfgs;
        if (U.isLocalNodeCoordinator(this.ctx.discovery())) {
            this.cacheStartProc.start(reqId, reqId);
        }
    }

    private IgniteInternalFuture<Boolean> cacheStart(UUID reqId) {
        if (this.ctx.clientNode()) {
            return new GridFinishedFuture<Boolean>();
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        Throwable err = (Throwable)opCtx0.err.get();
        if (err != null) {
            return new GridFinishedFuture<Boolean>(err);
        }
        if (!U.isLocalNodeCoordinator(this.ctx.discovery())) {
            return new GridFinishedFuture<Boolean>();
        }
        Collection<StoredCacheData> ccfgs = opCtx0.cfgs.values();
        if (this.log.isInfoEnabled()) {
            this.log.info("Starting restored caches [reqId=" + opCtx0.reqId + ", snapshot=" + opCtx0.snpName + ", caches=" + F.viewReadOnly(ccfgs, c -> c.config().getName(), new IgnitePredicate[0]) + ']');
        }
        return this.ctx.cache().dynamicStartCachesByStoredConf(ccfgs, true, true, false, IgniteUuid.fromUuid(reqId));
    }

    private void finishCacheStart(UUID reqId, Map<UUID, Boolean> res, Map<UUID, Exception> errs) {
        if (this.ctx.clientNode()) {
            return;
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        Exception failure = errs.values().stream().findFirst().orElse(this.checkNodeLeft(opCtx0.nodes, res.keySet()));
        if (failure == null) {
            this.finishProcess(reqId);
            return;
        }
        opCtx0.err.compareAndSet(null, failure);
        if (U.isLocalNodeCoordinator(this.ctx.discovery())) {
            this.rollbackRestoreProc.start(reqId, reqId);
        }
    }

    private Exception checkNodeLeft(Set<UUID> reqNodes, Set<UUID> respNodes) {
        if (!respNodes.containsAll(reqNodes)) {
            HashSet<UUID> leftNodes = new HashSet<UUID>(reqNodes);
            leftNodes.removeAll(respNodes);
            return new ClusterTopologyCheckedException("Cache group restore operation was rejected. Required node has left the cluster [nodeId=" + leftNodes + ']');
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<Boolean> rollback(UUID reqId) {
        if (this.ctx.clientNode()) {
            return new GridFinishedFuture<Boolean>();
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 == null || F.isEmpty(opCtx0.dirs)) {
            return new GridFinishedFuture<Boolean>();
        }
        GridFutureAdapter<Boolean> retFut = new GridFutureAdapter<Boolean>();
        SnapshotRestoreProcess snapshotRestoreProcess = this;
        synchronized (snapshotRestoreProcess) {
            opCtx0.stopFut = new IgniteFutureImpl<Object>(retFut.chain(f -> null));
            try {
                this.ctx.cache().context().snapshotMgr().snapshotExecutorService().execute(() -> {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Removing restored cache directories [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ", dirs=" + opCtx0.dirs + ']');
                    }
                    IgniteCheckedException ex = null;
                    for (File cacheDir : opCtx0.dirs) {
                        File tmpCacheDir = this.formatTmpDirName(cacheDir);
                        if (tmpCacheDir.exists() && !U.delete(tmpCacheDir)) {
                            this.log.error("Unable to perform rollback routine completely, cannot remove temp directory [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ", dir=" + tmpCacheDir + ']');
                            ex = new IgniteCheckedException("Unable to remove temporary cache directory " + cacheDir);
                        }
                        if (!cacheDir.exists() || U.delete(cacheDir)) continue;
                        this.log.error("Unable to perform rollback routine completely, cannot remove cache directory [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ", dir=" + cacheDir + ']');
                        ex = new IgniteCheckedException("Unable to remove cache directory " + cacheDir);
                    }
                    if (ex != null) {
                        retFut.onDone(ex);
                    } else {
                        retFut.onDone(true);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.log.error("Unable to perform rollback routine, task has been rejected [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ']');
                retFut.onDone(e);
            }
        }
        return retFut;
    }

    private void finishRollback(UUID reqId, Map<UUID, Boolean> res, Map<UUID, Exception> errs) {
        if (this.ctx.clientNode()) {
            return;
        }
        if (!errs.isEmpty()) {
            this.log.warning("Some nodes were unable to complete the rollback routine completely, check the local log files for more information [nodeIds=" + errs.keySet() + ']');
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (!res.keySet().containsAll(opCtx0.nodes)) {
            HashSet leftNodes = new HashSet(opCtx0.nodes);
            leftNodes.removeAll(res.keySet());
            this.log.warning("Some of the nodes left the cluster and were unable to complete the rollback operation [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ", node(s)=" + leftNodes + ']');
        }
        this.finishProcess(reqId, (Throwable)opCtx0.err.get());
    }

    private static class SnapshotRestoreContext {
        private final UUID reqId;
        private final String snpName;
        private final Set<UUID> nodes;
        private final Collection<File> dirs;
        private final AtomicReference<Throwable> err = new AtomicReference();
        private volatile Map<Integer, StoredCacheData> cfgs;
        private volatile IgniteFuture<?> stopFut;

        protected SnapshotRestoreContext(SnapshotOperationRequest req, Collection<File> dirs, Map<Integer, StoredCacheData> cfgs) {
            this.reqId = req.requestId();
            this.snpName = req.snapshotName();
            this.nodes = new HashSet<UUID>(req.nodes());
            this.dirs = dirs;
            this.cfgs = cfgs;
        }
    }
}

