/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotVerifyException;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskArg;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyUtility;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsTaskV2;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class SnapshotPartitionsVerifyTask
extends ComputeTaskAdapter<SnapshotPartitionsVerifyTaskArg, SnapshotPartitionsVerifyTaskResult> {
    private static final long serialVersionUID = 0L;
    private final Map<ClusterNode, List<SnapshotMetadata>> metas = new HashMap<ClusterNode, List<SnapshotMetadata>>();
    @IgniteInstanceResource
    private IgniteEx ignite;

    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable SnapshotPartitionsVerifyTaskArg arg) throws IgniteException {
        Map<ClusterNode, List<SnapshotMetadata>> clusterMetas = arg.clusterMetadata();
        if (!subgrid.containsAll(clusterMetas.keySet())) {
            throw new IgniteSnapshotVerifyException(F.asMap(this.ignite.localNode(), new IgniteException("Some of Ignite nodes left the cluster during the snapshot verification [curr=" + F.viewReadOnly(subgrid, F.node2id(), new IgnitePredicate[0]) + ", init=" + F.viewReadOnly(clusterMetas.keySet(), F.node2id(), new IgnitePredicate[0]) + ']')));
        }
        HashMap jobs = new HashMap();
        HashSet allMetas = new HashSet();
        clusterMetas.values().forEach(allMetas::addAll);
        HashSet<String> missed = null;
        for (SnapshotMetadata snapshotMetadata : allMetas) {
            if (missed == null) {
                missed = new HashSet<String>(snapshotMetadata.baselineNodes());
            }
            missed.remove(snapshotMetadata.consistentId());
            if (!missed.isEmpty()) continue;
            break;
        }
        if (!missed.isEmpty()) {
            throw new IgniteSnapshotVerifyException(F.asMap(this.ignite.localNode(), new IgniteException("Some metadata is missing from the snapshot: " + missed)));
        }
        this.metas.putAll(clusterMetas);
        block1: while (!allMetas.isEmpty()) {
            for (Map.Entry entry : clusterMetas.entrySet()) {
                IgnitePredicate[] ignitePredicateArray = new IgnitePredicate[1];
                ignitePredicateArray[0] = allMetas::remove;
                SnapshotMetadata meta = F.find((Iterable)entry.getValue(), null, ignitePredicateArray);
                if (meta == null) continue;
                jobs.put(new VisorVerifySnapshotPartitionsJob(meta.snapshotName(), meta.consistentId(), arg.cacheGroupNames()), entry.getKey());
                if (!allMetas.isEmpty()) continue;
                continue block1;
            }
        }
        return jobs;
    }

    @Override
    @Nullable
    public SnapshotPartitionsVerifyTaskResult reduce(List<ComputeJobResult> results) throws IgniteException {
        return new SnapshotPartitionsVerifyTaskResult(this.metas, VerifyBackupPartitionsTaskV2.reduce0(results));
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        return ComputeJobResultPolicy.WAIT;
    }

    private static class VisorVerifySnapshotPartitionsJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;
        private final String snpName;
        private final String consId;
        private final Set<String> rqGrps;

        public VisorVerifySnapshotPartitionsJob(String snpName, String consId, Collection<String> rqGrps) {
            this.snpName = snpName;
            this.consId = consId;
            this.rqGrps = rqGrps == null ? Collections.emptySet() : new HashSet<String>(rqGrps);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<PartitionKeyV2, PartitionHashRecordV2> execute() throws IgniteException {
            IgniteSnapshotManager snpMgr = this.ignite.context().cache().context().snapshotMgr();
            if (this.log.isInfoEnabled()) {
                this.log.info("Verify snapshot partitions procedure has been initiated [snpName=" + this.snpName + ", consId=" + this.consId + ']');
            }
            SnapshotMetadata meta = snpMgr.readSnapshotMetadata(this.snpName, this.consId);
            HashSet<Integer> grps = this.rqGrps.isEmpty() ? new HashSet<Integer>(meta.partitions().keySet()) : this.rqGrps.stream().map(GridCacheUtils::cacheId).collect(Collectors.toSet());
            HashSet<File> partFiles = new HashSet<File>();
            for (File dir : snpMgr.snapshotCacheDirectories(this.snpName, meta.folderName())) {
                int grpId = CU.cacheId(FilePageStoreManager.cacheGroupName(dir));
                if (!grps.remove(grpId)) continue;
                HashSet parts = new HashSet(meta.partitions().get(grpId));
                for (File part2 : FilePageStoreManager.cachePartitionFiles(dir)) {
                    int partId = FilePageStoreManager.partId(part2.getName());
                    if (!parts.remove(partId)) continue;
                    partFiles.add(part2);
                }
                if (parts.isEmpty()) continue;
                throw new IgniteException("Snapshot data doesn't contain required cache group partition [grpId=" + grpId + ", snpName=" + this.snpName + ", consId=" + this.consId + ", missed=" + parts + ", meta=" + meta + ']');
            }
            if (!grps.isEmpty()) {
                throw new IgniteException("Snapshot data doesn't contain required cache groups [grps=" + grps + ", snpName=" + this.snpName + ", consId=" + this.consId + ", meta=" + meta + ']');
            }
            ConcurrentHashMap<PartitionKeyV2, PartitionHashRecordV2> res = new ConcurrentHashMap<PartitionKeyV2, PartitionHashRecordV2>();
            ThreadLocal<ByteBuffer> buff = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(meta.pageSize()).order(ByteOrder.nativeOrder()));
            try {
                StandaloneGridKernalContext snpCtx = snpMgr.createStandaloneKernalContext(this.snpName, meta.folderName());
                for (GridComponent comp : snpCtx) {
                    comp.start();
                }
                try {
                    U.doInParallel(snpMgr.snapshotExecutorService(), partFiles, part -> {
                        String grpName = FilePageStoreManager.cacheGroupName(part.getParentFile());
                        int grpId = CU.cacheId(grpName);
                        int partId = FilePageStoreManager.partId(part.getName());
                        FilePageStoreManager storeMgr = (FilePageStoreManager)this.ignite.context().cache().context().pageStore();
                        try (FilePageStore pageStore = (FilePageStore)storeMgr.getPageStoreFactory(grpId, false).createPageStore(GroupPartitionId.getTypeByPartId(partId), part::toPath, val -> {});){
                            if (partId == 65535) {
                                IdleVerifyUtility.checkPartitionsPageCrcSum(() -> pageStore, 65535, (byte)2);
                                Object var12_13 = null;
                                return var12_13;
                            }
                            if (grpId == MetaStorage.METASTORAGE_CACHE_ID) {
                                IdleVerifyUtility.checkPartitionsPageCrcSum(() -> pageStore, partId, (byte)1);
                                Object var12_14 = null;
                                return var12_14;
                            }
                            ByteBuffer pageBuff = (ByteBuffer)buff.get();
                            pageBuff.clear();
                            pageStore.read(0L, pageBuff, true);
                            long pageAddr = GridUnsafe.bufferAddress(pageBuff);
                            PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(pageBuff);
                            GridDhtPartitionState partState = GridDhtPartitionState.fromOrdinal(io.getPartitionState(pageAddr));
                            if (partState != GridDhtPartitionState.OWNING) {
                                throw new IgniteCheckedException("Snapshot partitions must be in the OWNING state only: " + (Object)((Object)partState));
                            }
                            long updateCntr = io.getUpdateCounter(pageAddr);
                            long size = io.getSize(pageAddr);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Partition [grpId=" + grpId + ", id=" + partId + ", counter=" + updateCntr + ", size=" + size + "]");
                            }
                            PartitionKeyV2 key = new PartitionKeyV2(grpId, partId, grpName);
                            PartitionHashRecordV2 hash = IdleVerifyUtility.calculatePartitionHash(key, updateCntr, this.consId, GridDhtPartitionState.OWNING, false, size, snpMgr.partitionRowIterator(snpCtx, grpName, partId, pageStore));
                            assert (hash != null) : "OWNING must have hash: " + key;
                            res.put(key, hash);
                            return null;
                        }
                        catch (IOException e) {
                            throw new IgniteCheckedException(e);
                        }
                    });
                }
                finally {
                    for (GridComponent comp : snpCtx) {
                        comp.stop(true);
                    }
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            return res;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VisorVerifySnapshotPartitionsJob job = (VisorVerifySnapshotPartitionsJob)o;
            return this.snpName.equals(job.snpName) && this.consId.equals(job.consId);
        }

        public int hashCode() {
            return Objects.hash(this.snpName, this.consId);
        }
    }
}

