/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.jdbc;

import javax.cache.configuration.Factory;
import javax.sql.DataSource;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.store.jdbc.CacheJdbcBlobStore;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.resources.SpringApplicationContextResource;

public class CacheJdbcBlobStoreFactory<K, V>
implements Factory<CacheJdbcBlobStore<K, V>> {
    private static final long serialVersionUID = 0L;
    private String connUrl = "jdbc:h2:mem:jdbcCacheStore;DB_CLOSE_DELAY=-1";
    private String createTblQry = "create table if not exists ENTRIES (akey binary primary key, val binary)";
    private String loadQry = "select * from ENTRIES where akey=?";
    private String updateQry = "update ENTRIES set val=? where akey=?";
    private String insertQry = "insert into ENTRIES (akey, val) values (?, ?)";
    private String delQry = "delete from ENTRIES where akey=?";
    private String user;
    @GridToStringExclude
    private String passwd;
    private boolean initSchema = true;
    private String dataSrcBean;
    private transient DataSource dataSrc;
    @SpringApplicationContextResource
    private Object appCtx;

    public CacheJdbcBlobStore<K, V> create() {
        CacheJdbcBlobStore store = new CacheJdbcBlobStore();
        store.setInitSchema(this.initSchema);
        store.setConnectionUrl(this.connUrl);
        store.setCreateTableQuery(this.createTblQry);
        store.setLoadQuery(this.loadQry);
        store.setUpdateQuery(this.updateQry);
        store.setInsertQuery(this.insertQry);
        store.setDeleteQuery(this.delQry);
        store.setUser(this.user);
        store.setPassword(this.passwd);
        if (this.dataSrc != null) {
            store.setDataSource(this.dataSrc);
        } else if (this.dataSrcBean != null) {
            if (this.appCtx == null) {
                throw new IgniteException("Spring application context resource is not injected.");
            }
            try {
                IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
                DataSource data = (DataSource)spring.loadBeanFromAppContext(this.appCtx, this.dataSrcBean);
                store.setDataSource(data);
            }
            catch (IgniteCheckedException ignored) {
                throw new IgniteException("Failed to load bean in application context [beanName=" + this.dataSrcBean + ", igniteConfig=" + this.appCtx + ']');
            }
        }
        return store;
    }

    public CacheJdbcBlobStoreFactory<K, V> setInitSchema(boolean initSchema) {
        this.initSchema = initSchema;
        return this;
    }

    public CacheJdbcBlobStoreFactory<K, V> setConnectionUrl(String connUrl) {
        this.connUrl = connUrl;
        return this;
    }

    public CacheJdbcBlobStoreFactory<K, V> setCreateTableQuery(String createTblQry) {
        this.createTblQry = createTblQry;
        return this;
    }

    public CacheJdbcBlobStoreFactory<K, V> setLoadQuery(String loadQry) {
        this.loadQry = loadQry;
        return this;
    }

    public CacheJdbcBlobStoreFactory<K, V> setUpdateQuery(String updateQry) {
        this.updateQry = updateQry;
        return this;
    }

    public CacheJdbcBlobStoreFactory<K, V> setInsertQuery(String insertQry) {
        this.insertQry = insertQry;
        return this;
    }

    public CacheJdbcBlobStoreFactory<K, V> setDeleteQuery(String delQry) {
        this.delQry = delQry;
        return this;
    }

    public CacheJdbcBlobStoreFactory<K, V> setUser(String user) {
        this.user = user;
        return this;
    }

    public CacheJdbcBlobStoreFactory<K, V> setPassword(String passwd) {
        this.passwd = passwd;
        return this;
    }

    public CacheJdbcBlobStoreFactory<K, V> setDataSourceBean(String dataSrcBean) {
        this.dataSrcBean = dataSrcBean;
        return this;
    }

    public CacheJdbcBlobStoreFactory<K, V> setDataSource(DataSource dataSrc) {
        this.dataSrc = dataSrc;
        return this;
    }

    public String toString() {
        return S.toString(CacheJdbcBlobStoreFactory.class, this);
    }
}

