/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.ml.util.LRUCacheExpirationListener;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 4266640700294024306L;
    private final int cacheSize;
    private final LRUCacheExpirationListener<V> expirationLsnr;

    public LRUCache(int cacheSize) {
        this(cacheSize, e -> {});
    }

    public LRUCache(int cacheSize, LRUCacheExpirationListener<V> expirationLsnr) {
        super(10, 0.75f, true);
        this.cacheSize = cacheSize;
        this.expirationLsnr = expirationLsnr;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() > this.cacheSize) {
            this.expirationLsnr.entryExpired(eldest.getValue());
            return true;
        }
        return false;
    }
}

