/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.evaluator.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.selection.scoring.evaluator.context.EvaluationContext;
import org.apache.ignite.ml.structures.LabeledVector;

public class BinaryClassificationEvaluationContext<L extends Serializable>
implements EvaluationContext<L, BinaryClassificationEvaluationContext<L>> {
    private static final long serialVersionUID = 658785331349096576L;
    private L firstClsLbl;
    private L secondClsLbl;

    public BinaryClassificationEvaluationContext() {
        this.firstClsLbl = null;
        this.secondClsLbl = null;
    }

    public BinaryClassificationEvaluationContext(L firstClsLbl, L secondClsLbl) {
        this.firstClsLbl = firstClsLbl;
        this.secondClsLbl = secondClsLbl;
    }

    @Override
    public void aggregate(LabeledVector<L> vector) {
        Serializable lb = (Serializable)vector.label();
        if (this.firstClsLbl == null) {
            this.firstClsLbl = lb;
        } else if (this.secondClsLbl == null && !lb.equals(this.firstClsLbl)) {
            this.secondClsLbl = lb;
            this.swapLabelsIfNeed();
        } else {
            this.checkNewLabel(lb);
        }
    }

    private void swapLabelsIfNeed() {
        Comparable cmp1;
        int res;
        if (this.firstClsLbl instanceof Comparable && (res = (cmp1 = (Comparable)this.firstClsLbl).compareTo(this.secondClsLbl)) > 0) {
            L tmp = this.secondClsLbl;
            this.secondClsLbl = this.firstClsLbl;
            this.firstClsLbl = tmp;
        }
    }

    @Override
    public BinaryClassificationEvaluationContext<L> mergeWith(BinaryClassificationEvaluationContext<L> other) {
        this.checkNewLabel(other.firstClsLbl);
        this.checkNewLabel(other.secondClsLbl);
        List<Object> uniqLabels = new ArrayList<L>(4);
        uniqLabels.add(this.firstClsLbl);
        uniqLabels.add(this.secondClsLbl);
        uniqLabels.add(other.firstClsLbl);
        uniqLabels.add(other.secondClsLbl);
        Stream<Serializable> s = uniqLabels.stream().filter(Objects::nonNull).distinct();
        if (this.firstClsLbl instanceof Comparable || this.secondClsLbl instanceof Comparable || other.firstClsLbl instanceof Comparable || other.secondClsLbl instanceof Comparable) {
            s = s.sorted();
        }
        A.ensure(((uniqLabels = s.collect(Collectors.toList())).size() < 3 ? 1 : 0) != 0, (String)"labels.length < 3");
        return new BinaryClassificationEvaluationContext<Object>((uniqLabels.isEmpty() ? null : (Serializable)uniqLabels.get(0)), (uniqLabels.size() < 2 ? null : (Serializable)uniqLabels.get(1)));
    }

    public L getFirstClsLbl() {
        return this.firstClsLbl;
    }

    public L getSecondClsLbl() {
        return this.secondClsLbl;
    }

    private void checkNewLabel(L lb) {
        A.ensure((this.firstClsLbl == null || this.secondClsLbl == null || lb == null || lb.equals(this.firstClsLbl) || lb.equals(this.secondClsLbl) ? 1 : 0) != 0, (String)("Unable to collect binary classification ctx stat. There are more than two labels. First label = " + this.firstClsLbl + ", second label = " + this.secondClsLbl + ", another label = " + lb));
    }
}

