/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.naivebayes.gaussian;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.ml.math.util.MapUtil;

class GaussianNaiveBayesSumsHolder
implements Serializable,
AutoCloseable {
    private static final long serialVersionUID = 1L;
    Map<Double, double[]> featureSumsPerLbl = new HashMap<Double, double[]>();
    Map<Double, double[]> featureSquaredSumsPerLbl = new HashMap<Double, double[]>();
    Map<Double, Integer> featureCountersPerLbl = new HashMap<Double, Integer>();

    public Map<Double, double[]> getFeatureSumsPerLbl() {
        return this.featureSumsPerLbl;
    }

    public Map<Double, double[]> getFeatureSquaredSumsPerLbl() {
        return this.featureSquaredSumsPerLbl;
    }

    public Map<Double, Integer> getFeatureCountersPerLbl() {
        return this.featureCountersPerLbl;
    }

    GaussianNaiveBayesSumsHolder merge(GaussianNaiveBayesSumsHolder other) {
        this.featureSumsPerLbl = MapUtil.mergeMaps(this.featureSumsPerLbl, other.featureSumsPerLbl, this::sum, HashMap::new);
        this.featureSquaredSumsPerLbl = MapUtil.mergeMaps(this.featureSquaredSumsPerLbl, other.featureSquaredSumsPerLbl, this::sum, HashMap::new);
        this.featureCountersPerLbl = MapUtil.mergeMaps(this.featureCountersPerLbl, other.featureCountersPerLbl, (i1, i2) -> i1 + i2, HashMap::new);
        return this;
    }

    private double[] sum(double[] arr1, double[] arr2) {
        for (int i = 0; i < arr1.length; ++i) {
            int n = i;
            arr1[n] = arr1[n] + arr2[i];
        }
        return arr1;
    }

    @Override
    public void close() {
    }
}

