/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml;

import java.io.Serializable;
import java.util.function.BiFunction;
import org.apache.ignite.ml.inference.Model;
import org.apache.ignite.ml.math.functions.IgniteFunction;

@FunctionalInterface
public interface IgniteModel<T, V>
extends Model<T, V>,
Serializable {
    default public <X, W> IgniteModel<T, X> combine(IgniteModel<T, W> other, BiFunction<V, W, X> combiner) {
        return v -> combiner.apply(this.predict(v), other.predict(v));
    }

    default public <V1> IgniteModel<T, V1> andThen(final IgniteModel<V, V1> after) {
        final IgniteModel self = this;
        return new IgniteModel<T, V1>(){

            @Override
            public V1 predict(T input) {
                return after.predict(self.predict(input));
            }

            @Override
            public void close() {
                self.close();
                after.close();
            }
        };
    }

    default public <V1> IgniteModel<T, V1> andThen(final IgniteFunction<V, V1> after) {
        final IgniteModel self = this;
        return new IgniteModel<T, V1>(){

            @Override
            public V1 predict(T input) {
                return after.apply(self.predict(input));
            }

            @Override
            public void close() {
                self.close();
            }
        };
    }

    default public <V1> IgniteModel<V1, V> andBefore(final IgniteFunction<V1, T> before) {
        final IgniteModel self = this;
        return new IgniteModel<V1, V>(){

            @Override
            public V predict(V1 input) {
                return self.predict(before.apply(input));
            }

            @Override
            public void close() {
                self.close();
            }
        };
    }

    default public String toString(boolean pretty) {
        return this.getClass().getSimpleName();
    }

    @Override
    default public void close() {
    }
}

