/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.property.subcommands;

import java.util.Collection;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorTaskArgument;

public abstract class PropertyAbstractSubCommand<MetadataArgsDto extends IgniteDataTransferObject, MetadataResultDto extends IgniteDataTransferObject>
extends AbstractCommand<MetadataArgsDto> {
    private MetadataArgsDto args;

    @Override
    public final void printUsage(Logger log) {
        throw new UnsupportedOperationException("printUsage");
    }

    @Override
    public final void parseArguments(CommandArgIterator argIter) {
        this.args = this.parseArguments0(argIter);
    }

    @Override
    public final Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            GridClientCompute compute = client.compute();
            Collection nodes = compute.nodes(n -> n.connectable() && !n.isClient());
            if (F.isEmpty((Collection)nodes) && F.isEmpty((Collection)(nodes = compute.nodes(GridClientNode::connectable)))) {
                throw new GridClientDisconnectedException("Connectable nodes not found", null);
            }
            GridClientNode node = nodes.stream().findAny().orElse(null);
            if (node == null) {
                node = compute.balancer().balancedNode(nodes);
            }
            IgniteDataTransferObject res = (IgniteDataTransferObject)compute.projection(node).execute(this.taskName(), (Object)new VisorTaskArgument(node.nodeId(), this.arg(), false));
            this.printResult(res, log);
        }
        catch (Throwable e) {
            log.severe("Failed to execute metadata command='" + this.name() + "'");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
        return null;
    }

    @Override
    public final MetadataArgsDto arg() {
        return this.args;
    }

    protected abstract String taskName();

    protected MetadataArgsDto parseArguments0(CommandArgIterator argIter) {
        return null;
    }

    protected abstract void printResult(MetadataResultDto var1, Logger var2);
}

