/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.OutputFormat;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.ListCommandArg;
import org.apache.ignite.internal.processors.cache.verify.CacheInfo;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.cache.VisorCacheAffinityConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheConfigurationCollectorTask;
import org.apache.ignite.internal.visor.cache.VisorCacheConfigurationCollectorTaskArg;
import org.apache.ignite.internal.visor.cache.VisorCacheEvictionConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheNearConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheRebalanceConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheStoreConfiguration;
import org.apache.ignite.internal.visor.query.VisorQueryConfiguration;
import org.apache.ignite.internal.visor.verify.VisorViewCacheCmd;
import org.apache.ignite.internal.visor.verify.VisorViewCacheTask;
import org.apache.ignite.internal.visor.verify.VisorViewCacheTaskArg;
import org.apache.ignite.internal.visor.verify.VisorViewCacheTaskResult;

public class CacheViewer
extends AbstractCommand<Arguments> {
    private Arguments args;

    @Override
    public void printUsage(Logger logger) {
        String description = "Show information about caches, groups or sequences that match a regular expression. When executed without parameters, this subcommand prints the list of caches.";
        LinkedHashMap map = U.newLinkedHashMap((int)16);
        map.put(ListCommandArg.CONFIG.toString(), "print all configuration parameters for each cache.");
        map.put(ListCommandArg.OUTPUT_FORMAT + " " + (Object)((Object)OutputFormat.MULTI_LINE), "print configuration parameters per line. This option has effect only when used with " + ListCommandArg.CONFIG + " and without " + CommandLogger.optional(CommandLogger.or(ListCommandArg.GROUP, ListCommandArg.SEQUENCE)) + ".");
        map.put(ListCommandArg.GROUP.toString(), "print information about groups.");
        map.put(ListCommandArg.SEQUENCE.toString(), "print information about sequences.");
        CacheCommands.usageCache(logger, CacheSubcommands.LIST, description, map, "regexPattern", CommandLogger.optional(CommandLogger.or(ListCommandArg.GROUP, ListCommandArg.SEQUENCE)), CacheCommands.OP_NODE_ID, CommandLogger.optional(ListCommandArg.CONFIG), CommandLogger.optional(new Object[]{ListCommandArg.OUTPUT_FORMAT, OutputFormat.MULTI_LINE}));
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        VisorViewCacheTaskResult res;
        VisorViewCacheTaskArg taskArg = new VisorViewCacheTaskArg(this.args.regex(), this.args.cacheCommand());
        try (GridClient client = Command.startClient(clientCfg);){
            res = (VisorViewCacheTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorViewCacheTask.class.getName(), taskArg, this.args.nodeId(), clientCfg);
            if (this.args.fullConfig() && this.args.cacheCommand() == VisorViewCacheCmd.CACHES) {
                this.cachesConfig(client, this.args, res, clientCfg, logger);
            } else {
                this.printCacheInfos(res.cacheInfos(), this.args.cacheCommand(), logger);
            }
        }
        return res;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String regex = argIter.nextArg("Regex is expected");
        boolean fullConfig = false;
        VisorViewCacheCmd cacheCmd = VisorViewCacheCmd.CACHES;
        OutputFormat outputFormat = OutputFormat.SINGLE_LINE;
        UUID nodeId = null;
        while (argIter.hasNextSubArg()) {
            String nextArg = argIter.nextArg("").toLowerCase();
            ListCommandArg arg = CommandArgUtils.of(nextArg, ListCommandArg.class);
            if (arg != null) {
                switch (arg) {
                    case GROUP: {
                        cacheCmd = VisorViewCacheCmd.GROUPS;
                        break;
                    }
                    case SEQUENCE: {
                        cacheCmd = VisorViewCacheCmd.SEQ;
                        break;
                    }
                    case OUTPUT_FORMAT: {
                        String tmp2 = argIter.nextArg("output format must be defined!").toLowerCase();
                        outputFormat = OutputFormat.fromConsoleName(tmp2);
                        break;
                    }
                    case CONFIG: {
                        fullConfig = true;
                    }
                }
                continue;
            }
            nodeId = UUID.fromString(nextArg);
        }
        this.args = new Arguments(regex, fullConfig, nodeId, cacheCmd, outputFormat);
    }

    private static Map<String, Object> mapToPairs(VisorCacheConfiguration cfg) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        VisorCacheAffinityConfiguration affinityCfg = cfg.getAffinityConfiguration();
        VisorCacheNearConfiguration nearCfg = cfg.getNearConfiguration();
        VisorCacheRebalanceConfiguration rebalanceCfg = cfg.getRebalanceConfiguration();
        VisorCacheEvictionConfiguration evictCfg = cfg.getEvictionConfiguration();
        VisorCacheStoreConfiguration storeCfg = cfg.getStoreConfiguration();
        VisorQueryConfiguration qryCfg = cfg.getQueryConfiguration();
        params.put("Name", cfg.getName());
        params.put("Group", cfg.getGroupName());
        params.put("Dynamic Deployment ID", cfg.getDynamicDeploymentId());
        params.put("System", cfg.isSystem());
        params.put("Mode", cfg.getMode());
        params.put("Atomicity Mode", cfg.getAtomicityMode());
        params.put("Statistic Enabled", cfg.isStatisticsEnabled());
        params.put("Management Enabled", cfg.isManagementEnabled());
        params.put("On-heap cache enabled", cfg.isOnheapCacheEnabled());
        params.put("Partition Loss Policy", cfg.getPartitionLossPolicy());
        params.put("Query Parallelism", cfg.getQueryParallelism());
        params.put("Copy On Read", cfg.isCopyOnRead());
        params.put("Listener Configurations", cfg.getListenerConfigurations());
        params.put("Load Previous Value", cfg.isLoadPreviousValue());
        params.put("Memory Policy Name", cfg.getMemoryPolicyName());
        params.put("Node Filter", cfg.getNodeFilter());
        params.put("Read From Backup", cfg.isReadFromBackup());
        params.put("Topology Validator", cfg.getTopologyValidator());
        params.put("Time To Live Eager Flag", cfg.isEagerTtl());
        params.put("Write Synchronization Mode", cfg.getWriteSynchronizationMode());
        params.put("Invalidate", cfg.isInvalidate());
        params.put("Affinity Function", affinityCfg.getFunction());
        params.put("Affinity Backups", affinityCfg.getPartitionedBackups());
        params.put("Affinity Partitions", affinityCfg.getPartitions());
        params.put("Affinity Exclude Neighbors", affinityCfg.isExcludeNeighbors());
        params.put("Affinity Mapper", affinityCfg.getMapper());
        params.put("Rebalance Mode", rebalanceCfg.getMode());
        params.put("Rebalance Batch Size", rebalanceCfg.getBatchSize());
        params.put("Rebalance Timeout", rebalanceCfg.getTimeout());
        params.put("Rebalance Delay", rebalanceCfg.getPartitionedDelay());
        params.put("Time Between Rebalance Messages", rebalanceCfg.getThrottle());
        params.put("Rebalance Batches Count", rebalanceCfg.getBatchesPrefetchCnt());
        params.put("Rebalance Cache Order", rebalanceCfg.getRebalanceOrder());
        params.put("Eviction Policy Enabled", evictCfg.getPolicy() != null);
        params.put("Eviction Policy Factory", evictCfg.getPolicy());
        params.put("Eviction Policy Max Size", evictCfg.getPolicyMaxSize());
        params.put("Eviction Filter", evictCfg.getFilter());
        params.put("Near Cache Enabled", nearCfg.isNearEnabled());
        params.put("Near Start Size", nearCfg.getNearStartSize());
        params.put("Near Eviction Policy Factory", nearCfg.getNearEvictPolicy());
        params.put("Near Eviction Policy Max Size", nearCfg.getNearEvictMaxSize());
        params.put("Default Lock Timeout", cfg.getDefaultLockTimeout());
        params.put("Query Entities", cfg.getQueryEntities());
        params.put("Cache Interceptor", cfg.getInterceptor());
        params.put("Store Enabled", storeCfg.isEnabled());
        params.put("Store Class", storeCfg.getStore());
        params.put("Store Factory Class", storeCfg.getStoreFactory());
        params.put("Store Keep Binary", storeCfg.isStoreKeepBinary());
        params.put("Store Read Through", storeCfg.isReadThrough());
        params.put("Store Write Through", storeCfg.isWriteThrough());
        params.put("Store Write Coalescing", storeCfg.getWriteBehindCoalescing());
        params.put("Write-Behind Enabled", storeCfg.isWriteBehindEnabled());
        params.put("Write-Behind Flush Size", storeCfg.getFlushSize());
        params.put("Write-Behind Frequency", storeCfg.getFlushFrequency());
        params.put("Write-Behind Flush Threads Count", storeCfg.getFlushThreadCount());
        params.put("Write-Behind Batch Size", storeCfg.getBatchSize());
        params.put("Concurrent Asynchronous Operations Number", cfg.getMaxConcurrentAsyncOperations());
        params.put("Loader Factory Class Name", cfg.getLoaderFactory());
        params.put("Writer Factory Class Name", cfg.getWriterFactory());
        params.put("Expiry Policy Factory Class Name", cfg.getExpiryPolicyFactory());
        params.put("Query Execution Time Threshold", qryCfg.getLongQueryWarningTimeout());
        params.put("Query Escaped Names", qryCfg.isSqlEscapeAll());
        params.put("Query SQL Schema", qryCfg.getSqlSchema());
        params.put("Query SQL functions", qryCfg.getSqlFunctionClasses());
        params.put("Query Indexed Types", qryCfg.getIndexedTypes());
        params.put("Maximum payload size for offheap indexes", cfg.getSqlIndexMaxInlineSize());
        params.put("Query Metrics History Size", cfg.getQueryDetailMetricsSize());
        return params;
    }

    private void printCachesConfig(Map<String, VisorCacheConfiguration> caches, OutputFormat outputFormat, Map<String, Integer> cacheToMapped, Logger logger) {
        block3: for (Map.Entry<String, VisorCacheConfiguration> entry : caches.entrySet()) {
            String cacheName = entry.getKey();
            switch (outputFormat) {
                case MULTI_LINE: {
                    Map<String, Object> params = CacheViewer.mapToPairs(entry.getValue());
                    params.put("Mapped", cacheToMapped.get(cacheName));
                    logger.info(String.format("[cache = '%s']%n", cacheName));
                    for (Map.Entry<String, Object> innerEntry : params.entrySet()) {
                        logger.info(String.format("%s: %s%n", innerEntry.getKey(), innerEntry.getValue()));
                    }
                    logger.info("");
                    continue block3;
                }
            }
            int mapped = cacheToMapped.get(cacheName);
            logger.info(String.format("%s: %s %s=%s%n", entry.getKey(), this.toString(entry.getValue()), "mapped", mapped));
        }
    }

    private String toString(VisorCacheConfiguration cfg) {
        return cfg.toString().substring(cfg.getClass().getSimpleName().length() + 1);
    }

    private void cachesConfig(GridClient client, Arguments cacheArgs, VisorViewCacheTaskResult viewRes, GridClientConfiguration clientCfg, Logger logger) throws GridClientException {
        VisorCacheConfigurationCollectorTaskArg taskArg = new VisorCacheConfigurationCollectorTaskArg(cacheArgs.regex());
        UUID nodeId = cacheArgs.nodeId() == null ? TaskExecutor.BROADCAST_UUID : cacheArgs.nodeId();
        Map res = (Map)TaskExecutor.executeTaskByNameOnNode(client, VisorCacheConfigurationCollectorTask.class.getName(), taskArg, nodeId, clientCfg);
        Map<String, Integer> cacheToMapped = viewRes.cacheInfos().stream().collect(Collectors.toMap(CacheInfo::getCacheName, CacheInfo::getMapped));
        this.printCachesConfig(res, cacheArgs.outputFormat(), cacheToMapped, logger);
    }

    private void printCacheInfos(Collection<CacheInfo> infos, VisorViewCacheCmd cmd, Logger logger) {
        for (CacheInfo info : infos) {
            Map map = info.toMap(cmd);
            SB sb = new SB("[");
            for (Map.Entry e : map.entrySet()) {
                sb.a((String)e.getKey()).a("=").a(e.getValue()).a(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.a("]");
            logger.info(sb.toString());
        }
    }

    @Override
    public String name() {
        return CacheSubcommands.LIST.text().toUpperCase();
    }

    public static class Arguments {
        private String regex;
        private boolean fullConfig;
        private UUID nodeId;
        private VisorViewCacheCmd cacheCmd;
        private OutputFormat outputFormat;

        public Arguments(String regex, boolean fullConfig, UUID nodeId, VisorViewCacheCmd cacheCmd, OutputFormat outputFormat) {
            this.regex = regex;
            this.fullConfig = fullConfig;
            this.nodeId = nodeId;
            this.cacheCmd = cacheCmd;
            this.outputFormat = outputFormat;
        }

        public String regex() {
            return this.regex;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public OutputFormat outputFormat() {
            return this.outputFormat;
        }

        public VisorViewCacheCmd cacheCommand() {
            return this.cacheCmd;
        }

        public boolean fullConfig() {
            return this.fullConfig;
        }
    }
}

