/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.Comparator;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.visor.misc.VisorClusterChangeTagTask;
import org.apache.ignite.internal.visor.misc.VisorClusterChangeTagTaskArg;
import org.apache.ignite.internal.visor.misc.VisorClusterChangeTagTaskResult;

public class ClusterChangeTagCommand
extends AbstractCommand<String> {
    private static final String ERR_NO_NEW_TAG_PROVIDED = "Please provide new tag.";
    private static final String ERR_EMPTY_TAG_PROVIDED = "Please provide non-empty tag.";
    private String newTagArg;

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            UUID coordinatorId = client.compute().nodes().stream().min(Comparator.comparingLong(GridClientNode::order)).map(GridClientNode::nodeId).orElse(null);
            VisorClusterChangeTagTaskResult res = (VisorClusterChangeTagTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorClusterChangeTagTask.class.getName(), this.toVisorArguments(), coordinatorId, clientCfg);
            if (res.success().booleanValue()) {
                logger.info("Cluster tag updated successfully, old tag was: " + res.tag());
            } else {
                logger.warning("Error has occurred during tag update: " + res.errorMessage());
            }
        }
        catch (Throwable e) {
            logger.severe("Failed to execute Cluster ID and tag command: ");
            logger.severe(CommandLogger.errorMessage(e));
            throw e;
        }
        return null;
    }

    @Override
    public String arg() {
        return this.newTagArg;
    }

    @Override
    public void printUsage(Logger logger) {
        Command.usage(logger, "Change cluster tag to new value:", CommandList.CLUSTER_CHANGE_TAG, "newTagValue", CommandLogger.optional("--yes"));
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        if (!argIter.hasNextSubArg()) {
            throw new IllegalArgumentException(ERR_NO_NEW_TAG_PROVIDED);
        }
        this.newTagArg = argIter.nextArg(ERR_NO_NEW_TAG_PROVIDED);
        if (this.newTagArg == null || this.newTagArg.isEmpty()) {
            throw new IllegalArgumentException(ERR_EMPTY_TAG_PROVIDED);
        }
    }

    @Override
    public String name() {
        return CommandList.CLUSTER_CHANGE_TAG.toCommandName();
    }

    @Override
    public String confirmationPrompt() {
        return "Warning: the command will change cluster tag.";
    }

    private VisorClusterChangeTagTaskArg toVisorArguments() {
        return new VisorClusterChangeTagTaskArg(this.newTagArg);
    }
}

