/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.osgi.classloaders;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.osgi.framework.Bundle;

public class BundleDelegatingClassLoader
extends ClassLoader {
    protected final Bundle bundle;
    @GridToStringExclude
    protected final ClassLoader clsLdr;

    public BundleDelegatingClassLoader(Bundle bundle) {
        this(bundle, null);
    }

    public BundleDelegatingClassLoader(Bundle bundle, ClassLoader classLoader) {
        this.bundle = bundle;
        this.clsLdr = classLoader;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.bundle.loadClass(name);
    }

    @Override
    protected URL findResource(String name) {
        URL resource = this.bundle.getResource(name);
        if (resource == null && this.clsLdr != null) {
            resource = this.clsLdr.getResource(name);
        }
        return resource;
    }

    protected Enumeration findResources(String name) throws IOException {
        return this.bundle.getResources(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls;
        try {
            cls = this.findClass(name);
        }
        catch (ClassNotFoundException ignored) {
            if (this.clsLdr == null) {
                throw this.classNotFoundException(name);
            }
            try {
                cls = this.clsLdr.loadClass(name);
            }
            catch (ClassNotFoundException ignored2) {
                throw this.classNotFoundException(name);
            }
        }
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String toString() {
        return S.toString(BundleDelegatingClassLoader.class, (Object)this);
    }

    protected ClassNotFoundException classNotFoundException(String clsName) {
        String s = "Failed to resolve class [name=" + clsName + ", bundleId=" + this.bundle.getBundleId() + ", symbolicName=" + this.bundle.getSymbolicName() + ", fallbackClsLdr=" + this.clsLdr + ']';
        return new ClassNotFoundException(s);
    }
}

