/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.osgi.IgniteOsgiUtils;
import org.apache.ignite.osgi.classloaders.BundleDelegatingClassLoader;
import org.apache.ignite.osgi.classloaders.ContainerSweepClassLoader;
import org.apache.ignite.osgi.classloaders.OsgiClassLoadingStrategyType;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class IgniteAbstractOsgiContextActivator
implements BundleActivator {
    public static final String OSGI_SERVICE_PROP_IGNITE_NAME = "ignite.name";
    protected Ignite ignite;
    private BundleContext bundleCtx;
    private IgniteLogger log;

    public final void start(BundleContext ctx) throws Exception {
        if (IgniteOsgiUtils.gridCount() > 0) {
            throw new IgniteException("Failed to start Ignite instance (another instance is already running and ignite-osgi is currently limited to a single instance per container).");
        }
        this.bundleCtx = ctx;
        IgniteConfiguration cfg = this.igniteConfiguration();
        A.notNull((Object)cfg, (String)"Ignite configuration");
        BundleDelegatingClassLoader clsLdr = this.classLoadingStrategy() == OsgiClassLoadingStrategyType.BUNDLE_DELEGATING ? new BundleDelegatingClassLoader(this.bundleCtx.getBundle(), Ignite.class.getClassLoader()) : new ContainerSweepClassLoader(this.bundleCtx.getBundle(), Ignite.class.getClassLoader());
        cfg.setClassLoader((ClassLoader)clsLdr);
        this.onBeforeStart(ctx);
        try {
            this.ignite = Ignition.start((IgniteConfiguration)cfg);
        }
        catch (Throwable t) {
            U.error((IgniteLogger)this.log, (Object)("Failed to start Ignite via OSGi Activator [errMsg=" + t.getMessage() + ']'), (Throwable)t);
            this.onAfterStart(ctx, t);
            return;
        }
        this.log = this.ignite.log();
        if (this.log.isInfoEnabled()) {
            this.log.info("Started Ignite from OSGi Activator [name=" + this.ignite.name() + ']');
        }
        IgniteOsgiUtils.classloaders().put(this.ignite, clsLdr);
        this.exportOsgiService(this.ignite);
        this.onAfterStart(ctx, null);
    }

    public final void stop(BundleContext ctx) throws Exception {
        this.onBeforeStop(ctx);
        try {
            this.ignite.close();
        }
        catch (Throwable t) {
            U.error((IgniteLogger)this.log, (Object)("Failed to stop Ignite via OSGi Activator [errMsg=" + t.getMessage() + ']'), (Throwable)t);
            this.onAfterStop(ctx, t);
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Stopped Ignite from OSGi Activator [name=" + this.ignite.name() + ']');
        }
        IgniteOsgiUtils.classloaders().remove(this.ignite);
        this.onAfterStop(ctx, null);
    }

    protected void onBeforeStart(BundleContext ctx) {
    }

    protected void onAfterStart(BundleContext ctx, @Nullable Throwable t) {
    }

    protected void onBeforeStop(BundleContext ctx) {
    }

    protected void onAfterStop(BundleContext ctx, @Nullable Throwable t) {
    }

    public abstract IgniteConfiguration igniteConfiguration();

    public OsgiClassLoadingStrategyType classLoadingStrategy() {
        return OsgiClassLoadingStrategyType.BUNDLE_DELEGATING;
    }

    private void exportOsgiService(Ignite ignite) {
        Hashtable<String, String> dict = new Hashtable<String, String>();
        if (ignite.name() != null) {
            ((Dictionary)dict).put(OSGI_SERVICE_PROP_IGNITE_NAME, ignite.name());
        }
        this.bundleCtx.registerService(Ignite.class, (Object)ignite, dict);
        if (this.log.isInfoEnabled()) {
            this.log.info("Exported OSGi service for Ignite with properties: " + dict);
        }
    }
}

