/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.buffer;

import io.netty.channel.DefaultFileRegion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.LimitedInputStream;
import org.apache.spark.network.util.TransportConf;
import org.spark_project.guava.base.Objects;
import org.spark_project.guava.io.ByteStreams;

public final class FileSegmentManagedBuffer
extends ManagedBuffer {
    private final TransportConf conf;
    private final File file;
    private final long offset;
    private final long length;

    public FileSegmentManagedBuffer(TransportConf conf, File file, long offset, long length) {
        this.conf = conf;
        this.file = file;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public ByteBuffer nioByteBuffer() throws IOException {
        MappedByteBuffer buf2;
        FileChannel channel;
        block9: {
            channel = null;
            channel = new RandomAccessFile(this.file, "r").getChannel();
            if (this.length >= (long)this.conf.memoryMapBytes()) break block9;
            ByteBuffer buf2 = ByteBuffer.allocate((int)this.length);
            channel.position(this.offset);
            while (buf2.remaining() != 0) {
                if (channel.read(buf2) != -1) continue;
                throw new IOException(String.format("Reached EOF before filling buffer\noffset=%s\nfile=%s\nbuf.remaining=%s", this.offset, this.file.getAbsoluteFile(), buf2.remaining()));
            }
            buf2.flip();
            ByteBuffer byteBuffer = buf2;
            JavaUtils.closeQuietly(channel);
            return byteBuffer;
        }
        try {
            buf2 = channel.map(FileChannel.MapMode.READ_ONLY, this.offset, this.length);
        }
        catch (IOException e) {
            try {
                String errorMessage = "Error in reading " + this;
                try {
                    if (channel != null) {
                        long size = channel.size();
                        errorMessage = "Error in reading " + this + " (actual file length " + size + ")";
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new IOException(errorMessage, e);
            }
            catch (Throwable throwable) {
                JavaUtils.closeQuietly(channel);
                throw throwable;
            }
        }
        JavaUtils.closeQuietly(channel);
        return buf2;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        FileInputStream is = null;
        boolean shouldClose = true;
        try {
            is = new FileInputStream(this.file);
            ByteStreams.skipFully(is, this.offset);
            LimitedInputStream r = new LimitedInputStream(is, this.length);
            shouldClose = false;
            LimitedInputStream limitedInputStream = r;
            return limitedInputStream;
        }
        catch (IOException e) {
            String errorMessage = "Error in reading " + this;
            if (is != null) {
                long size = this.file.length();
                errorMessage = "Error in reading " + this + " (actual file length " + size + ")";
            }
            throw new IOException(errorMessage, e);
        }
        finally {
            if (shouldClose) {
                JavaUtils.closeQuietly(is);
            }
        }
    }

    @Override
    public ManagedBuffer retain() {
        return this;
    }

    @Override
    public ManagedBuffer release() {
        return this;
    }

    @Override
    public Object convertToNetty() throws IOException {
        if (this.conf.lazyFileDescriptor()) {
            return new DefaultFileRegion(this.file, this.offset, this.length);
        }
        FileChannel fileChannel = FileChannel.open(this.file.toPath(), StandardOpenOption.READ);
        return new DefaultFileRegion(fileChannel, this.offset, this.length);
    }

    public File getFile() {
        return this.file;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("file", this.file).add("offset", this.offset).add("length", this.length).toString();
    }
}

