/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc;

import java.sql.PreparedStatement;
import java.util.Map;
import org.apache.ignite.yardstick.jdbc.AbstractJdbcBenchmark;
import org.apache.ignite.yardstick.jdbc.DisjointRangeGenerator;
import org.yardstickframework.BenchmarkConfiguration;

public class JdbcSqlUpdateBenchmark
extends AbstractJdbcBenchmark {
    private final ThreadLocal<PreparedStatement> singleUpdate = this.newStatement("UPDATE test_long SET val = (val + 1) WHERE id = ?");
    private final ThreadLocal<PreparedStatement> rangeUpdate = this.newStatement("UPDATE test_long SET val = (val + 1) WHERE id BETWEEN ? AND ?");
    private DisjointRangeGenerator idGen;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.idGen = new DisjointRangeGenerator(cfg.threads(), this.args.range(), this.args.sqlRange());
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        PreparedStatement update;
        long expResSize = this.idGen.rangeWidth();
        long startId = this.idGen.nextRangeStartId();
        long endId = this.idGen.endRangeId(startId);
        if (this.idGen.rangeWidth() == 1L) {
            update = this.singleUpdate.get();
            update.setLong(1, startId);
        } else {
            update = this.rangeUpdate.get();
            update.setLong(1, startId);
            update.setLong(2, endId);
        }
        int actualResSize = update.executeUpdate();
        if ((long)actualResSize != expResSize) {
            throw new Exception("Invalid result set size [actual=" + actualResSize + ", expected=" + expResSize + ']');
        }
        return true;
    }
}

