/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.yardstick.jdbc.AbstractJdbcBenchmark;
import org.apache.ignite.yardstick.jdbc.SelectCommand;
import org.yardstickframework.BenchmarkConfiguration;

public class JdbcSqlQueryRangeBenchmark
extends AbstractJdbcBenchmark {
    private ThreadLocal<PreparedStatement> stmtRange;
    private ThreadLocal<PreparedStatement> stmtSingle;
    private SelectCommand select;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.select = this.args.selectCommand();
        this.stmtRange = this.newStatement(this.select.selectRange());
        this.stmtSingle = this.newStatement(this.select.selectOne());
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        long expRsSize;
        long id;
        PreparedStatement stmt;
        if (this.args.sqlRange() == 1) {
            stmt = this.stmtSingle.get();
            id = ThreadLocalRandom.current().nextLong(this.args.range()) + 1L;
            stmt.setLong(1, this.select.fieldByPK(id));
            expRsSize = 1L;
        } else {
            stmt = this.stmtRange.get();
            id = ThreadLocalRandom.current().nextLong(this.args.range() - this.args.sqlRange()) + 1L;
            long maxId = id + (long)this.args.sqlRange() - 1L;
            stmt.setLong(1, this.select.fieldByPK(id));
            stmt.setLong(2, this.select.fieldByPK(maxId));
            expRsSize = this.args.sqlRange();
        }
        long rsSize = 0L;
        try (ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                if (rs.getLong(1) + 1L != rs.getLong(2)) {
                    throw new Exception("Invalid result retrieved");
                }
                ++rsSize;
            }
        }
        if (rsSize != expRsSize) {
            throw new Exception("Invalid result set size [actual=" + rsSize + ", expected=" + expRsSize + ']');
        }
        return true;
    }
}

