/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;

public class IgnitePutAllBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private static final Integer PUT_MAPS_KEY = 2048;
    private static final Integer PUT_MAPS_CNT = 256;
    private Affinity<Integer> aff;
    private int srvrCnt;
    private int stripesCnt;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.aff = this.ignite().affinity(this.cache().getName());
        Collection nodes = this.ignite().cluster().forServers().nodes();
        this.stripesCnt = this.ignite().cluster().forServers().forRandom().metrics().getTotalCpus();
        this.srvrCnt = nodes.size();
        IgniteLogger log = this.ignite().log();
        if (log.isInfoEnabled()) {
            log.info("Servers info [srvrsCnt=" + this.srvrCnt + ", stripesCnt=" + this.stripesCnt + ']');
        }
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        Map<Integer, Integer> vals;
        ArrayList<Map<Integer, Integer>> putMaps = (ArrayList<Map<Integer, Integer>>)ctx.get(PUT_MAPS_KEY);
        if (putMaps == null) {
            putMaps = new ArrayList<Map<Integer, Integer>>(PUT_MAPS_CNT);
            ctx.put(PUT_MAPS_KEY, putMaps);
        }
        if (putMaps.size() == PUT_MAPS_CNT.intValue()) {
            vals = (Map)putMaps.get(IgnitePutAllBenchmark.nextRandom(PUT_MAPS_CNT));
        } else {
            IgniteLogger log;
            vals = new TreeMap();
            ClusterNode node = this.args.collocated() ? this.aff.mapKeyToNode((Object)IgnitePutAllBenchmark.nextRandom(this.args.range())) : null;
            HashMap stripesMap = null;
            if (this.args.singleStripe()) {
                stripesMap = U.newHashMap((int)this.srvrCnt);
            }
            while (vals.size() < this.args.batch()) {
                int key = IgnitePutAllBenchmark.nextRandom(this.args.range());
                if (this.args.collocated() && !this.aff.isPrimary(node, (Object)key)) continue;
                if (this.args.singleStripe()) {
                    int part = this.aff.partition((Object)key);
                    ClusterNode node0 = node != null ? node : this.aff.mapPartitionToNode(part);
                    Integer stripe0 = (Integer)stripesMap.get(node0);
                    int stripe = part % this.stripesCnt;
                    if (stripe0 != null) {
                        if (stripe0 != stripe) {
                            continue;
                        }
                    } else {
                        stripesMap.put(node0, stripe);
                    }
                }
                vals.put(key, key);
            }
            putMaps.add(vals);
            if (putMaps.size() == PUT_MAPS_CNT.intValue() && (log = this.ignite().log()).isInfoEnabled()) {
                log.info("Put maps set generated.");
            }
        }
        IgniteCache cache = this.cacheForOperation();
        cache.putAll(vals);
        return true;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("atomic");
    }
}

