/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.events.Event;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public abstract class IgniteAbstractPageReplacementBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private static final String CACHE_NAME = "CacheWithReplacement";
    private static final String SCAN_CACHE_NAME = "ScanCache";
    private volatile int replCntr = 0x3FFFFFFF;
    private volatile Thread backgroundScanThread;
    private volatile int range;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        Throwable throwable;
        super.setUp(cfg);
        int progress = 0;
        final AtomicBoolean replacement = new AtomicBoolean();
        this.ignite().events().remoteListen((IgniteBiPredicate)new IgniteBiPredicate<UUID, Event>(){

            public boolean apply(UUID uuid, Event evt) {
                if (evt.type() == 142) {
                    replacement.set(true);
                    return false;
                }
                return true;
            }
        }, null, new int[]{142});
        int portion = 100;
        HashMap<Integer, TestValue> putMap = new HashMap<Integer, TestValue>(portion, 1.0f);
        while (progress < 2 * this.replCntr) {
            putMap.clear();
            for (int i = 0; i < portion; ++i) {
                putMap.put(progress + i, new TestValue(progress + i));
            }
            this.cache().putAll(putMap);
            if ((progress += portion) % 1000 == 0) {
                BenchmarkUtils.println((String)("progress=" + progress));
            }
            if (!replacement.compareAndSet(true, false)) continue;
            if (this.replCntr != 0x3FFFFFFF) {
                throw new Exception("Invalid expected val: " + this.replCntr);
            }
            this.replCntr = progress;
            BenchmarkUtils.println((String)("replCntr=" + this.replCntr));
        }
        BenchmarkUtils.println((String)("Benchmark cache fullfill complete. progress=" + progress + " replCntr=" + this.replCntr + "."));
        long backgroundScanInterval = this.args.getLongParameter("BACKGROUND_SCAN_INTERVAL", 0L);
        if (backgroundScanInterval != 0L) {
            IgniteCache scanCache = this.ignite().getOrCreateCache(SCAN_CACHE_NAME);
            throwable = null;
            try (IgniteDataStreamer streamer = this.ignite().dataStreamer(SCAN_CACHE_NAME);){
                for (int i = 0; i < this.replCntr; ++i) {
                    streamer.addData((Object)i, (Object)new TestValue(i));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            BenchmarkUtils.println((String)("Scan cache fullfill complete. Size=" + this.replCntr + "."));
            this.backgroundScanThread = new Thread(() -> {
                long iteration = 0L;
                while (this.ignite().cluster().state().active()) {
                    ++iteration;
                    long size = 0L;
                    try (QueryCursor cursor = scanCache.query((Query)new ScanQuery());){
                        for (Object o : cursor) {
                            ++size;
                        }
                    }
                    BenchmarkUtils.println((String)("Background scan iteration " + iteration + " finished, size=" + size));
                    try {
                        Thread.sleep(backgroundScanInterval);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            });
            this.backgroundScanThread.start();
        }
        int cacheSize = 0;
        throwable = null;
        try (QueryCursor cursor = this.cache.query((Query)new ScanQuery());){
            for (Object o : cursor) {
                ++cacheSize;
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        BenchmarkUtils.println((String)("cache size=" + cacheSize));
        this.range = (int)(this.args.getDoubleParameter("REPLACE_RATIO", 1.0) * (double)this.replCntr);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.backgroundScanThread != null) {
            this.backgroundScanThread.interrupt();
            this.backgroundScanThread.join();
        }
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().getOrCreateCache(CACHE_NAME);
    }

    protected int nextKey() {
        return IgniteAbstractPageReplacementBenchmark.nextRandom(this.range);
    }

    protected static class TestValue
    implements Serializable {
        private int id;
        @QuerySqlField(index=true)
        private final byte[] payload = new byte[64];

        protected TestValue(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public boolean hasPayload() {
            return this.payload != null;
        }
    }
}

