/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.generators.primitives.vector;

import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.util.generators.primitives.scalar.RandomProducer;
import org.apache.ignite.ml.util.generators.primitives.vector.VectorGenerator;

public class ParametricVectorGenerator
implements VectorGenerator {
    private final List<IgniteFunction<Double, Double>> perDimensionGenerators;
    private final RandomProducer randomProducer;

    public ParametricVectorGenerator(RandomProducer paramGenerator, IgniteFunction<Double, Double> ... perDimensionGenerators) {
        A.notEmpty((Object[])perDimensionGenerators, (String)"perDimensionGenerators.length != 0");
        this.perDimensionGenerators = Arrays.asList(perDimensionGenerators);
        this.randomProducer = paramGenerator;
    }

    @Override
    public Vector get() {
        Double t = (Double)this.randomProducer.get();
        return VectorUtils.of(this.perDimensionGenerators.stream().mapToDouble(f -> (Double)f.apply(t)).toArray());
    }
}

