/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.impurity.gini;

import org.apache.ignite.ml.tree.impurity.ImpurityMeasure;

public class GiniImpurityMeasure
implements ImpurityMeasure<GiniImpurityMeasure> {
    private static final long serialVersionUID = 5338129703395229970L;
    private final long[] left;
    private final long[] right;

    GiniImpurityMeasure(long[] left, long[] right) {
        assert (left.length == right.length) : "Left and right parts have to be the same length";
        this.left = left;
        this.right = right;
    }

    @Override
    public double impurity() {
        long leftCnt = 0L;
        long rightCnt = 0L;
        double leftImpurity = 0.0;
        double rightImpurity = 0.0;
        for (long e : this.left) {
            leftCnt += e;
        }
        for (long e : this.right) {
            rightCnt += e;
        }
        if (leftCnt > 0L) {
            for (long e : this.left) {
                leftImpurity += Math.pow(e, 2.0) / (double)leftCnt;
            }
        }
        if (rightCnt > 0L) {
            for (long e : this.right) {
                rightImpurity += Math.pow(e, 2.0) / (double)rightCnt;
            }
        }
        return -(leftImpurity + rightImpurity);
    }

    @Override
    public GiniImpurityMeasure add(GiniImpurityMeasure b) {
        assert (this.left.length == b.left.length) : "Subtracted measure has to have length " + this.left.length;
        assert (this.left.length == b.right.length) : "Subtracted measure has to have length " + this.left.length;
        long[] leftRes = new long[this.left.length];
        long[] rightRes = new long[this.left.length];
        for (int i = 0; i < this.left.length; ++i) {
            leftRes[i] = this.left[i] + b.left[i];
            rightRes[i] = this.right[i] + b.right[i];
        }
        return new GiniImpurityMeasure(leftRes, rightRes);
    }

    @Override
    public GiniImpurityMeasure subtract(GiniImpurityMeasure b) {
        assert (this.left.length == b.left.length) : "Subtracted measure has to have length " + this.left.length;
        assert (this.left.length == b.right.length) : "Subtracted measure has to have length " + this.left.length;
        long[] leftRes = new long[this.left.length];
        long[] rightRes = new long[this.left.length];
        for (int i = 0; i < this.left.length; ++i) {
            leftRes[i] = this.left[i] - b.left[i];
            rightRes[i] = this.right[i] - b.right[i];
        }
        return new GiniImpurityMeasure(leftRes, rightRes);
    }

    public long[] getLeft() {
        return this.left;
    }

    public long[] getRight() {
        return this.right;
    }
}

