/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.data;

import java.util.Arrays;
import org.apache.ignite.ml.tree.TreeFilter;

public class TreeDataIndex {
    private final int[][] idx;
    private final double[][] features;
    private final double[] labels;

    public TreeDataIndex(double[][] features, double[] labels) {
        this.features = features;
        this.labels = labels;
        int rows = features.length;
        int cols = features.length == 0 ? 0 : features[0].length;
        double[][] featuresCp = new double[rows][cols];
        this.idx = new int[rows][cols];
        for (int row = 0; row < rows; ++row) {
            Arrays.fill(this.idx[row], row);
            featuresCp[row] = Arrays.copyOf(features[row], cols);
        }
        for (int col = 0; col < cols; ++col) {
            this.sortIndex(featuresCp, col, 0, rows - 1);
        }
    }

    private TreeDataIndex(int[][] idxProj, double[][] features, double[] labels) {
        this.idx = idxProj;
        this.features = features;
        this.labels = labels;
    }

    public double labelInSortedOrder(int k, int featureId) {
        return this.labels[this.idx[k][featureId]];
    }

    public double[] featuresInSortedOrder(int k, int featureId) {
        return this.features[this.idx[k][featureId]];
    }

    public double featureInSortedOrder(int k, int featureId) {
        return this.featuresInSortedOrder(k, featureId)[featureId];
    }

    public TreeDataIndex filter(TreeFilter filter) {
        int projSize = 0;
        for (int i = 0; i < this.rowsCount(); ++i) {
            if (!filter.test(this.featuresInSortedOrder(i, 0))) continue;
            ++projSize;
        }
        int[][] prj = new int[projSize][this.columnsCount()];
        for (int feature = 0; feature < this.columnsCount(); ++feature) {
            int ptr = 0;
            for (int row = 0; row < this.rowsCount(); ++row) {
                if (!filter.test(this.featuresInSortedOrder(row, feature))) continue;
                prj[ptr++][feature] = this.idx[row][feature];
            }
        }
        return new TreeDataIndex(prj, this.features, this.labels);
    }

    public int rowsCount() {
        return this.idx.length;
    }

    public int columnsCount() {
        return this.rowsCount() == 0 ? 0 : this.idx[0].length;
    }

    private void sortIndex(double[][] features, int col, int from, int to) {
        if (from < to) {
            double pivot = features[(from + to) / 2][col];
            int i = from;
            int j = to;
            while (i <= j) {
                while (features[i][col] < pivot) {
                    ++i;
                }
                while (features[j][col] > pivot) {
                    --j;
                }
                if (i > j) continue;
                double tmpFeature = features[i][col];
                features[i][col] = features[j][col];
                features[j][col] = tmpFeature;
                int tmpLb = this.idx[i][col];
                this.idx[i][col] = this.idx[j][col];
                this.idx[j][col] = tmpLb;
                ++i;
                --j;
            }
            this.sortIndex(features, col, from, j);
            this.sortIndex(features, col, i, to);
        }
    }
}

