/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.recommendation.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class MatrixFactorizationGradient<O extends Serializable, S extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -213199977280252181L;
    private final Map<O, Vector> objGrad;
    private final Map<S, Vector> subjGrad;
    private final int rows;

    public MatrixFactorizationGradient(Map<O, Vector> objGrad, Map<S, Vector> subjGrad, int rows) {
        this.objGrad = Collections.unmodifiableMap(objGrad);
        this.subjGrad = Collections.unmodifiableMap(subjGrad);
        this.rows = rows;
    }

    public void applyGradient(Map<O, Vector> objMatrix, Map<S, Vector> subjMatrix) {
        Vector vector;
        for (Map.Entry<O, Vector> entry : this.objGrad.entrySet()) {
            vector = objMatrix.get(entry.getKey());
            objMatrix.put(entry.getKey(), vector.minus(entry.getValue().divide(this.rows)));
        }
        for (Map.Entry<Object, Vector> entry : this.subjGrad.entrySet()) {
            vector = subjMatrix.get(entry.getKey());
            subjMatrix.put(entry.getKey(), vector.minus(entry.getValue().divide(this.rows)));
        }
    }

    public Map<O, Vector> getObjGrad() {
        return this.objGrad;
    }

    public Map<S, Vector> getSubjGrad() {
        return this.subjGrad;
    }

    public int getRows() {
        return this.rows;
    }
}

