/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.standardscaling;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.structures.LabeledVector;

public final class StandardScalerPreprocessor<K, V>
implements Preprocessor<K, V>,
DeployableObject {
    private static final long serialVersionUID = -5977957318991608203L;
    private final double[] means;
    private final double[] sigmas;
    private final Preprocessor<K, V> basePreprocessor;

    public StandardScalerPreprocessor(double[] means, double[] sigmas, Preprocessor<K, V> basePreprocessor) {
        assert (means.length == sigmas.length);
        this.means = means;
        this.sigmas = sigmas;
        this.basePreprocessor = basePreprocessor;
    }

    @Override
    public LabeledVector apply(K k, V v) {
        LabeledVector res = (LabeledVector)this.basePreprocessor.apply(k, v);
        assert (res.size() == this.means.length);
        for (int i = 0; i < res.size(); ++i) {
            res.set(i, (res.get(i) - this.means[i]) / this.sigmas[i]);
        }
        return res;
    }

    public double[] getMeans() {
        return this.means;
    }

    public double[] getSigmas() {
        return this.sigmas;
    }

    @Override
    public List<Object> getDependencies() {
        return Collections.singletonList(this.basePreprocessor);
    }
}

