/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.tostring;

import java.io.Externalizable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.tostring.GridToStringClassDescriptor;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringFieldDescriptor;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.tostring.GridToStringOrder;
import org.apache.ignite.internal.util.tostring.SBLengthLimit;
import org.apache.ignite.internal.util.tostring.SBLimitedLength;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridToStringBuilder {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Map<String, GridToStringClassDescriptor> classCache = new ConcurrentHashMap<String, GridToStringClassDescriptor>();
    public static final int DFLT_TO_STRING_MAX_LENGTH = 10000;
    public static final boolean DFLT_TO_STRING_INCLUDE_SENSITIVE = true;
    private static final AtomicReference<Supplier<Boolean>> INCL_SENS_SUP_REF = new AtomicReference<1>(new Supplier<Boolean>(){
        final boolean INCLUDE_SENSITIVE = IgniteSystemProperties.getBoolean("IGNITE_TO_STRING_INCLUDE_SENSITIVE", true);

        @Override
        public Boolean get() {
            return this.INCLUDE_SENSITIVE;
        }
    });
    public static final int DFLT_TO_STRING_COLLECTION_LIMIT = 100;
    private static final int COLLECTION_LIMIT = IgniteSystemProperties.getInteger("IGNITE_TO_STRING_COLLECTION_LIMIT", 100);
    private static ThreadLocal<SBLimitedLength> threadLocSB = new ThreadLocal<SBLimitedLength>(){

        @Override
        protected SBLimitedLength initialValue() {
            SBLimitedLength sb = new SBLimitedLength(256);
            sb.initLimit(new SBLengthLimit());
            return sb;
        }
    };
    private static ThreadLocal<IdentityHashMap<Object, EntryReference>> savedObjects = ThreadLocal.withInitial(() -> new IdentityHashMap());

    public static void setIncludeSensitiveSupplier(Supplier<Boolean> sup) {
        assert (Objects.nonNull(sup));
        INCL_SENS_SUP_REF.set(sup);
    }

    public static boolean includeSensitive() {
        return Holder.INCL_SENS_SUP.get();
    }

    public static String identity(Object obj) {
        return '@' + Integer.toHexString(System.identityHashCode(obj));
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3, String name4, Object val4) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false, name4, val4, false);
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3, String name4, Object val4, String name5, Object val5) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false, name4, val4, false, name5, val5, false);
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3, String name4, Object val4, String name5, Object val5, String name6, Object val6) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false, name4, val4, false, name5, val5, false, name6, val6, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3, String name4, Object val4, boolean sens4) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        Object[] addNames = new Object[5];
        Object[] addVals = new Object[5];
        boolean[] addSens = new boolean[5];
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        addNames[4] = name4;
        addVals[4] = val4;
        addSens[4] = sens4;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 5);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3, String name4, Object val4, boolean sens4, String name5, Object val5, boolean sens5) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        assert (name5 != null);
        Object[] addNames = new Object[6];
        Object[] addVals = new Object[6];
        boolean[] addSens = new boolean[6];
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        addNames[4] = name4;
        addVals[4] = val4;
        addSens[4] = sens4;
        addNames[5] = name5;
        addVals[5] = val5;
        addSens[5] = sens5;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 6);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3, String name4, Object val4, boolean sens4, String name5, Object val5, boolean sens5, String name6, Object val6, boolean sens6) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        assert (name5 != null);
        assert (name6 != null);
        Object[] addNames = new Object[7];
        Object[] addVals = new Object[7];
        boolean[] addSens = new boolean[7];
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        addNames[4] = name4;
        addVals[4] = val4;
        addSens[4] = sens4;
        addNames[5] = name5;
        addVals[5] = val5;
        addSens[5] = sens5;
        addNames[6] = name6;
        addVals[6] = val6;
        addSens[6] = sens6;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 7);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        Object[] addNames = new Object[4];
        Object[] addVals = new Object[4];
        boolean[] addSens = new boolean[4];
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 4);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        Object[] addNames = new Object[3];
        Object[] addVals = new Object[3];
        boolean[] addSens = new boolean[3];
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 3);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        Object[] addNames = new Object[2];
        Object[] addVals = new Object[2];
        boolean[] addSens = new boolean[2];
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 2);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name, @Nullable Object val) {
        return GridToStringBuilder.toString(cls, obj, name, val, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name, @Nullable Object val, boolean sens) {
        assert (cls != null);
        assert (obj != null);
        assert (name != null);
        Object[] addNames = new Object[1];
        Object[] addVals = new Object[1];
        boolean[] addSens = new boolean[1];
        addNames[0] = name;
        addVals[0] = val;
        addSens[0] = sens;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 1);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj) {
        assert (cls != null);
        assert (obj != null);
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, sb, obj, EMPTY_ARRAY, EMPTY_ARRAY, null, 0);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String parent) {
        return parent != null ? GridToStringBuilder.toString(cls, obj, "super", (Object)parent) : GridToStringBuilder.toString(cls, obj);
    }

    private static void toString(SBLimitedLength buf, Object val) {
        GridToStringBuilder.toString(buf, null, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void toString(SBLimitedLength buf, Class<?> cls, Object val) {
        if (val == null) {
            buf.a("null");
            return;
        }
        if (cls == null) {
            cls = val.getClass();
        }
        if (cls.isPrimitive()) {
            buf.a(val);
            return;
        }
        IdentityHashMap<Object, EntryReference> svdObjs = savedObjects.get();
        if (GridToStringBuilder.handleRecursion(buf, val, cls, svdObjs)) {
            return;
        }
        svdObjs.put(val, new EntryReference(buf.length()));
        try {
            if (cls.isArray()) {
                GridToStringBuilder.addArray(buf, cls, val);
            } else if (val instanceof Collection) {
                GridToStringBuilder.addCollection(buf, (Collection)val);
            } else if (val instanceof Map) {
                GridToStringBuilder.addMap(buf, (Map)val);
            } else {
                buf.a(val);
            }
        }
        finally {
            svdObjs.remove(val);
        }
    }

    private static void addArray(SBLimitedLength buf, Class arrType, Object obj) {
        if (arrType.getComponentType().isPrimitive()) {
            buf.a(GridToStringBuilder.arrayToString(obj));
            return;
        }
        Object[] arr = (Object[])obj;
        buf.a(arrType.getSimpleName()).a(" [");
        for (int i = 0; i < arr.length; ++i) {
            GridToStringBuilder.toString(buf, arr[i]);
            if (i == COLLECTION_LIMIT - 1 || i == arr.length - 1) break;
            buf.a(", ");
        }
        GridToStringBuilder.handleOverflow(buf, arr.length);
        buf.a(']');
    }

    private static void addCollection(SBLimitedLength buf, Collection col) {
        buf.a(col.getClass().getSimpleName()).a(" [");
        int cnt = 0;
        for (Object obj : col) {
            GridToStringBuilder.toString(buf, obj);
            if (++cnt == COLLECTION_LIMIT || cnt == col.size()) break;
            buf.a(", ");
        }
        GridToStringBuilder.handleOverflow(buf, col.size());
        buf.a(']');
    }

    private static <K, V> void addMap(SBLimitedLength buf, Map<K, V> map) {
        buf.a(map.getClass().getSimpleName()).a(" {");
        int cnt = 0;
        for (Map.Entry<K, V> e : map.entrySet()) {
            GridToStringBuilder.toString(buf, e.getKey());
            buf.a('=');
            GridToStringBuilder.toString(buf, e.getValue());
            if (++cnt == COLLECTION_LIMIT || cnt == map.size()) break;
            buf.a(", ");
        }
        GridToStringBuilder.handleOverflow(buf, map.size());
        buf.a('}');
    }

    private static void handleOverflow(SBLimitedLength buf, int size) {
        int overflow = size - COLLECTION_LIMIT;
        if (overflow > 0) {
            buf.a("... and ").a(overflow).a(" more");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> String toStringImpl(Class<T> cls, SBLimitedLength buf, T obj, Object[] addNames, Object[] addVals, @Nullable boolean[] addSens, int addLen) {
        assert (cls != null);
        assert (buf != null);
        assert (obj != null);
        assert (addNames != null);
        assert (addVals != null);
        assert (addNames.length == addVals.length);
        assert (addLen <= addNames.length);
        boolean newStr = buf.length() == 0;
        IdentityHashMap<Object, EntryReference> svdObjs = savedObjects.get();
        if (newStr) {
            svdObjs.put(obj, new EntryReference(buf.length()));
        }
        try {
            int len = buf.length();
            String s = GridToStringBuilder.toStringImpl0(cls, buf, obj, addNames, addVals, addSens, addLen);
            if (newStr) {
                String string = s;
                return string;
            }
            buf.setLength(len);
            String string = s.substring(len);
            return string;
        }
        finally {
            if (newStr) {
                svdObjs.remove(obj);
            }
        }
    }

    private static <T> String toStringImpl0(Class<T> cls, SBLimitedLength buf, T obj, Object[] addNames, Object[] addVals, @Nullable boolean[] addSens, int addLen) {
        try {
            GridToStringClassDescriptor cd = GridToStringBuilder.getClassDescriptor(cls);
            assert (cd != null);
            buf.a(cd.getSimpleClassName());
            EntryReference ref = savedObjects.get().get(obj);
            if (ref != null && ref.hashNeeded) {
                buf.a(GridToStringBuilder.identity(obj));
                ref.hashNeeded = false;
            }
            buf.a(" [");
            boolean first = true;
            for (GridToStringFieldDescriptor fd : cd.getFields()) {
                if (!first) {
                    buf.a(", ");
                } else {
                    first = false;
                }
                buf.a(fd.getName()).a('=');
                switch (fd.type()) {
                    case 0: {
                        GridToStringBuilder.toString(buf, fd.fieldClass(), GridUnsafe.getObjectField(obj, fd.offset()));
                        break;
                    }
                    case 1: {
                        buf.a(GridUnsafe.getByteField(obj, fd.offset()));
                        break;
                    }
                    case 2: {
                        buf.a(GridUnsafe.getBooleanField(obj, fd.offset()));
                        break;
                    }
                    case 3: {
                        buf.a(GridUnsafe.getCharField(obj, fd.offset()));
                        break;
                    }
                    case 4: {
                        buf.a(GridUnsafe.getShortField(obj, fd.offset()));
                        break;
                    }
                    case 5: {
                        buf.a(GridUnsafe.getIntField(obj, fd.offset()));
                        break;
                    }
                    case 6: {
                        buf.a(GridUnsafe.getFloatField(obj, fd.offset()));
                        break;
                    }
                    case 7: {
                        buf.a(GridUnsafe.getLongField(obj, fd.offset()));
                        break;
                    }
                    case 8: {
                        buf.a(GridUnsafe.getDoubleField(obj, fd.offset()));
                    }
                }
            }
            GridToStringBuilder.appendVals(buf, first, addNames, addVals, addSens, addLen);
            buf.a(']');
            return buf.toString();
        }
        catch (Exception e) {
            classCache.remove(cls.getName() + System.identityHashCode(cls.getClassLoader()));
            throw new IgniteException(e);
        }
    }

    public static String toString(String str, String name, @Nullable Object val) {
        return GridToStringBuilder.toString(str, name, val, false);
    }

    public static String arrayToString(Object arr) {
        String res;
        int arrLen;
        if (arr == null) {
            return "null";
        }
        if (arr instanceof Object[]) {
            Object[] objArr = (Object[])arr;
            arrLen = objArr.length;
            if (arrLen > COLLECTION_LIMIT) {
                objArr = Arrays.copyOf(objArr, COLLECTION_LIMIT);
            }
            res = Arrays.toString(objArr);
        } else {
            res = GridToStringBuilder.toStringWithLimit(arr, COLLECTION_LIMIT);
            arrLen = Array.getLength(arr);
        }
        if (arrLen > COLLECTION_LIMIT) {
            StringBuilder resSB = new StringBuilder(res);
            resSB.deleteCharAt(resSB.length() - 1);
            resSB.append("... and ").append(arrLen - COLLECTION_LIMIT).append(" more]");
            res = resSB.toString();
        }
        return res;
    }

    private static String toStringWithLimit(Object arr, int limit) {
        int arrIdxMax = Array.getLength(arr) - 1;
        if (arrIdxMax == -1) {
            return "[]";
        }
        int idxMax = Math.min(arrIdxMax, limit);
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i <= idxMax; ++i) {
            b.append(Array.get(arr, i));
            if (i == idxMax) {
                return b.append(']').toString();
            }
            b.append(", ");
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name, @Nullable Object val, boolean sens) {
        assert (name != null);
        Object[] propNames = new Object[1];
        Object[] propVals = new Object[1];
        boolean[] propSens = new boolean[1];
        propNames[0] = name;
        propVals[0] = val;
        propSens[0] = sens;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 1);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static String toString(String str, String name0, @Nullable Object val0, String name1, @Nullable Object val1) {
        return GridToStringBuilder.toString(str, name0, val0, false, name1, val1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1) {
        assert (name0 != null);
        assert (name1 != null);
        Object[] propNames = new Object[2];
        Object[] propVals = new Object[2];
        boolean[] propSens = new boolean[2];
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 2);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        Object[] propNames = new Object[3];
        Object[] propVals = new Object[3];
        boolean[] propSens = new boolean[3];
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 3);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        Object[] propNames = new Object[4];
        Object[] propVals = new Object[4];
        boolean[] propSens = new boolean[4];
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 4);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3, String name4, @Nullable Object val4, boolean sens4) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        Object[] propNames = new Object[5];
        Object[] propVals = new Object[5];
        boolean[] propSens = new boolean[5];
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        propNames[4] = name4;
        propVals[4] = val4;
        propSens[4] = sens4;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 5);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3, String name4, @Nullable Object val4, boolean sens4, String name5, @Nullable Object val5, boolean sens5) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        assert (name5 != null);
        Object[] propNames = new Object[6];
        Object[] propVals = new Object[6];
        boolean[] propSens = new boolean[6];
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        propNames[4] = name4;
        propVals[4] = val4;
        propSens[4] = sens4;
        propNames[5] = name5;
        propVals[5] = val5;
        propSens[5] = sens5;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 6);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3, String name4, @Nullable Object val4, boolean sens4, String name5, @Nullable Object val5, boolean sens5, String name6, @Nullable Object val6, boolean sens6) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        assert (name5 != null);
        assert (name6 != null);
        Object[] propNames = new Object[7];
        Object[] propVals = new Object[7];
        boolean[] propSens = new boolean[7];
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        propNames[4] = name4;
        propVals[4] = val4;
        propSens[4] = sens4;
        propNames[5] = name5;
        propVals[5] = val5;
        propSens[5] = sens5;
        propNames[6] = name6;
        propVals[6] = val6;
        propSens[6] = sens6;
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 7);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, Object ... triplets) {
        if (triplets.length % 3 != 0) {
            throw new IllegalArgumentException("Array length must be a multiple of 3");
        }
        int propCnt = triplets.length / 3;
        Object[] propNames = new Object[propCnt];
        Object[] propVals = new Object[propCnt];
        boolean[] propSens = new boolean[propCnt];
        for (int i = 0; i < propCnt; ++i) {
            Object name = triplets[i * 3];
            assert (name != null);
            propNames[i] = name;
            propVals[i] = triplets[i * 3 + 1];
            Object sens = triplets[i * 3 + 2];
            assert (sens instanceof Boolean);
            propSens[i] = (Boolean)sens;
        }
        SBLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = GridToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, propCnt);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    private static String toStringImpl(String str, SBLimitedLength buf, Object[] propNames, Object[] propVals, boolean[] propSens, int propCnt) {
        boolean newStr;
        boolean bl = newStr = buf.length() == 0;
        if (str != null) {
            buf.a(str).a(" ");
        }
        buf.a("[");
        GridToStringBuilder.appendVals(buf, true, propNames, propVals, propSens, propCnt);
        buf.a(']');
        if (newStr) {
            return buf.toString();
        }
        return "";
    }

    private static void appendVals(SBLimitedLength buf, boolean first, Object[] addNames, Object[] addVals, boolean[] addSens, int addLen) {
        if (addLen > 0) {
            for (int i = 0; i < addLen; ++i) {
                GridToStringInclude incAnn;
                Object addVal = addVals[i];
                if (addVal != null && (addSens != null && addSens[i] && !GridToStringBuilder.includeSensitive() || (incAnn = addVal.getClass().getAnnotation(GridToStringInclude.class)) != null && incAnn.sensitive() && !GridToStringBuilder.includeSensitive())) continue;
                if (!first) {
                    buf.a(", ");
                } else {
                    first = false;
                }
                buf.a(addNames[i]).a('=');
                GridToStringBuilder.toString(buf, addVal);
            }
        }
    }

    private static <T> GridToStringClassDescriptor getClassDescriptor(Class<T> cls) {
        assert (cls != null);
        String key = cls.getName() + System.identityHashCode(cls.getClassLoader());
        GridToStringClassDescriptor cd = classCache.get(key);
        if (cd == null) {
            cd = new GridToStringClassDescriptor(cls);
            for (Field f : cls.getDeclaredFields()) {
                boolean add = false;
                Class<?> type = f.getType();
                GridToStringInclude incFld = f.getAnnotation(GridToStringInclude.class);
                GridToStringInclude incType = type.getAnnotation(GridToStringInclude.class);
                if (incFld != null || incType != null) {
                    boolean notSens = !(incFld != null && incFld.sensitive() || incType != null && incType.sensitive());
                    add = notSens || GridToStringBuilder.includeSensitive();
                } else if (!(f.isAnnotationPresent(GridToStringExclude.class) || type.isAnnotationPresent(GridToStringExclude.class) || !Modifier.isPrivate(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || Object.class == type || Serializable.class == type || Externalizable.class == type || type.isArray() || EventListener.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type) || OutputStream.class.isAssignableFrom(type) || Thread.class.isAssignableFrom(type) || Runnable.class.isAssignableFrom(type) || Lock.class.isAssignableFrom(type) || ReadWriteLock.class.isAssignableFrom(type) || Condition.class.isAssignableFrom(type))) {
                    add = true;
                }
                if (!add) continue;
                GridToStringFieldDescriptor fd = new GridToStringFieldDescriptor(f);
                GridToStringOrder annOrder = f.getAnnotation(GridToStringOrder.class);
                if (annOrder != null) {
                    fd.setOrder(annOrder.value());
                }
                cd.addField(fd);
            }
            cd.sortFields();
            classCache.putIfAbsent(key, cd);
        }
        return cd;
    }

    public static String compact(Collection<Integer> col) {
        return GridToStringBuilder.compact(col, i -> i + 1);
    }

    public static <T extends Number> String compact(Collection<T> col, Function<T, T> nextValFun) {
        Number left;
        assert (Objects.nonNull(col));
        assert (Objects.nonNull(nextValFun));
        if (col.isEmpty()) {
            return "[]";
        }
        SB sb = new SB();
        sb.a('[');
        ArrayList<T> l = new ArrayList<T>(col);
        Collections.sort(l);
        Number right = left = (Number)l.get(0);
        for (int i = 1; i < l.size(); ++i) {
            Number val = (Number)l.get(i);
            if (((Comparable)((Object)right)).compareTo(val) == 0 || ((Comparable)((Object)((Number)nextValFun.apply(right)))).compareTo(val) == 0) {
                right = val;
                continue;
            }
            if (((Comparable)((Object)left)).compareTo(right) == 0) {
                sb.a(left);
            } else {
                sb.a(left).a('-').a(right);
            }
            sb.a(',').a(' ');
            left = right = val;
        }
        if (((Comparable)((Object)left)).compareTo(right) == 0) {
            sb.a(left);
        } else {
            sb.a(left).a('-').a(right);
        }
        sb.a(']');
        return sb.toString();
    }

    private static boolean handleRecursion(SBLimitedLength buf, Object obj, @NotNull Class cls, IdentityHashMap<Object, EntryReference> svdObjs) {
        EntryReference ref = svdObjs.get(obj);
        if (ref == null) {
            return false;
        }
        int pos = ref.pos;
        String name = cls.getSimpleName();
        String hash = GridToStringBuilder.identity(obj);
        String savedName = name + hash;
        String charsAtPos = buf.impl().substring(pos, pos + savedName.length());
        if (!buf.isOverflowed() && !savedName.equals(charsAtPos)) {
            if (charsAtPos.startsWith(cls.getSimpleName())) {
                buf.i(pos + name.length(), hash);
                GridToStringBuilder.incValues(svdObjs, obj, hash.length());
            } else {
                ref.hashNeeded = true;
            }
        }
        buf.a(savedName);
        return true;
    }

    private static void incValues(IdentityHashMap<Object, EntryReference> svdObjs, Object obj, int hashLen) {
        int baseline = svdObjs.get((Object)obj).pos;
        for (Map.Entry<Object, EntryReference> entry : svdObjs.entrySet()) {
            EntryReference ref = entry.getValue();
            int pos = ref.pos;
            if (pos <= baseline) continue;
            ref.pos = pos + hashLen;
        }
    }

    static /* synthetic */ AtomicReference access$000() {
        return INCL_SENS_SUP_REF;
    }

    private static class EntryReference {
        int pos;
        boolean hashNeeded;

        private EntryReference(int pos) {
            this.pos = pos;
            this.hashNeeded = false;
        }
    }

    private static class Holder {
        static final Supplier<Boolean> INCL_SENS_SUP = (Supplier)GridToStringBuilder.access$000().get();

        private Holder() {
        }
    }
}

