/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CompactablePageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.lang.IgniteInClosure;

public abstract class BPlusIO<L>
extends PageIO
implements CompactablePageIO {
    private static final int CNT_OFF = 40;
    private static final int FORWARD_OFF = 42;
    private static final int REMOVE_ID_OFF = 50;
    protected static final int ITEMS_OFF = 58;
    private final boolean canGetRow;
    private final boolean leaf;
    protected final int itemSize;

    protected BPlusIO(int type, int ver, boolean leaf, boolean canGetRow, int itemSize) {
        super(type, ver);
        assert (itemSize > 0) : itemSize;
        assert (canGetRow || !leaf) : "leaf page always must be able to get full row";
        this.leaf = leaf;
        this.canGetRow = canGetRow;
        this.itemSize = itemSize;
    }

    public final int getItemSize() {
        return this.itemSize;
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize, PageMetrics metrics) {
        super.initNewPage(pageAddr, pageId, pageSize, metrics);
        this.setCount(pageAddr, 0);
        this.setForward(pageAddr, 0L);
        this.setRemoveId(pageAddr, 0L);
    }

    public final long getForward(long pageAddr) {
        return PageUtils.getLong(pageAddr, 42);
    }

    public final void setForward(long pageAddr, long pageId) {
        PageUtils.putLong(pageAddr, 42, pageId);
        assert (this.getForward(pageAddr) == pageId);
    }

    public final long getRemoveId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 50);
    }

    public final void setRemoveId(long pageAddr, long rmvId) {
        PageUtils.putLong(pageAddr, 50, rmvId);
        assert (this.getRemoveId(pageAddr) == rmvId);
    }

    public final int getCount(long pageAddr) {
        int cnt = PageUtils.getShort(pageAddr, 40) & 0xFFFF;
        assert (cnt >= 0) : cnt;
        return cnt;
    }

    public final void setCount(long pageAddr, int cnt) {
        assert (cnt >= 0) : cnt;
        PageUtils.putShort(pageAddr, 40, (short)cnt);
        assert (this.getCount(pageAddr) == cnt);
    }

    public final boolean canGetRow() {
        return this.canGetRow;
    }

    public final boolean isLeaf() {
        return this.leaf;
    }

    public abstract int getMaxCount(long var1, int var3);

    public final byte[] store(long pageAddr, int idx, L row, byte[] rowBytes, boolean needRowBytes) throws IgniteCheckedException {
        int off = this.offset(idx);
        if (rowBytes == null) {
            this.storeByOffset(pageAddr, off, row);
            if (needRowBytes) {
                rowBytes = PageUtils.getBytes(pageAddr, off, this.getItemSize());
            }
        } else {
            BPlusIO.putBytes(pageAddr, off, rowBytes);
        }
        return rowBytes;
    }

    public abstract int offset(int var1);

    public abstract void storeByOffset(long var1, int var3, L var4) throws IgniteCheckedException;

    public abstract void store(long var1, int var3, BPlusIO<L> var4, long var5, int var7) throws IgniteCheckedException;

    public abstract L getLookupRow(BPlusTree<L, ?> var1, long var2, int var4) throws IgniteCheckedException;

    public abstract void copyItems(long var1, long var3, int var5, int var6, int var7, boolean var8) throws IgniteCheckedException;

    public byte[] insert(long pageAddr, int idx, L row, byte[] rowBytes, long rightId, boolean needRowBytes) throws IgniteCheckedException {
        int cnt = this.getCount(pageAddr);
        this.copyItems(pageAddr, pageAddr, idx, idx + 1, cnt - idx, false);
        this.setCount(pageAddr, cnt + 1);
        return this.store(pageAddr, idx, row, rowBytes, needRowBytes);
    }

    public void splitForwardPage(long pageAddr, long fwdId, long fwdPageAddr, int mid, int cnt, int pageSize, PageMetrics metrics) throws IgniteCheckedException {
        this.initNewPage(fwdPageAddr, fwdId, pageSize, metrics);
        this.copyItems(pageAddr, fwdPageAddr, mid, 0, cnt -= mid, true);
        this.setCount(fwdPageAddr, cnt);
        this.setForward(fwdPageAddr, this.getForward(pageAddr));
        this.setRemoveId(fwdPageAddr, this.getRemoveId(pageAddr));
    }

    public void splitExistingPage(long pageAddr, int mid, long fwdId) {
        this.setCount(pageAddr, mid);
        this.setForward(pageAddr, fwdId);
    }

    public void remove(long pageAddr, int idx, int cnt) throws IgniteCheckedException {
        this.copyItems(pageAddr, pageAddr, idx + 1, idx, --cnt - idx, false);
        this.setCount(pageAddr, cnt);
    }

    public boolean merge(BPlusIO<L> prntIo, long prntPageAddr, int prntIdx, long leftPageAddr, long rightPageAddr, boolean emptyBranch, int pageSize) throws IgniteCheckedException {
        int prntCnt = prntIo.getCount(prntPageAddr);
        int leftCnt = this.getCount(leftPageAddr);
        int rightCnt = this.getCount(rightPageAddr);
        int newCnt = leftCnt + rightCnt;
        if (!this.isLeaf() && !emptyBranch) {
            ++newCnt;
        }
        if (newCnt > this.getMaxCount(leftPageAddr, pageSize)) {
            assert (!emptyBranch);
            return false;
        }
        this.setCount(leftPageAddr, newCnt);
        if (!this.isLeaf() && !emptyBranch) {
            assert (prntIdx >= 0 && prntIdx < prntCnt) : prntIdx;
            this.store(leftPageAddr, leftCnt, prntIo, prntPageAddr, prntIdx);
            ++leftCnt;
        }
        this.copyItems(rightPageAddr, leftPageAddr, 0, leftCnt, rightCnt, !emptyBranch);
        this.setForward(leftPageAddr, this.getForward(rightPageAddr));
        long rmvId = this.getRemoveId(rightPageAddr);
        if (rmvId > this.getRemoveId(leftPageAddr)) {
            this.setRemoveId(leftPageAddr, rmvId);
        }
        return true;
    }

    private static void putBytes(long pageAddr, int pos, byte[] bytes) {
        PageUtils.putBytes(pageAddr, pos, bytes);
    }

    public void visit(long pageAddr, IgniteInClosure<L> c) {
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        sb.a("BPlusIO [\n\tcanGetRow=").a(this.canGetRow).a(",\n\tleaf=").a(this.leaf).a(",\n\titemSize=").a(this.itemSize).a(",\n\tcnt=").a(this.getCount(addr)).a(",\n\tforward=").appendHex(this.getForward(addr)).a(",\n\tremoveId=").appendHex(this.getRemoveId(addr)).a("\n]");
    }

    public int getItemsEnd(long pageAddr) {
        int cnt = this.getCount(pageAddr);
        return this.offset(cnt);
    }

    @Override
    public void compactPage(ByteBuffer page, ByteBuffer out, int pageSize) {
        this.copyPage(page, out, pageSize);
        long pageAddr = GridUnsafe.bufferAddress(out);
        out.limit(this.getItemsEnd(pageAddr));
    }

    @Override
    public void restorePage(ByteBuffer compactPage, int pageSize) {
        assert (compactPage.isDirect());
        assert (compactPage.position() == 0);
        assert (compactPage.limit() <= pageSize);
        compactPage.limit(pageSize);
    }
}

