/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class SnapshotMetadata
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final UUID rqId;
    private final String snpName;
    private final String consId;
    private final String folderName;
    private final int pageSize;
    @GridToStringInclude
    private final List<Integer> grpIds;
    @GridToStringInclude
    private final Set<String> bltNodes;
    @GridToStringInclude
    private final Map<Integer, Set<Integer>> locParts = new HashMap<Integer, Set<Integer>>();

    public SnapshotMetadata(UUID rqId, String snpName, String consId, String folderName, int pageSize, List<Integer> grpIds, Set<String> bltNodes, Set<GroupPartitionId> pairs) {
        this.rqId = rqId;
        this.snpName = snpName;
        this.consId = consId;
        this.folderName = folderName;
        this.pageSize = pageSize;
        this.grpIds = grpIds;
        this.bltNodes = bltNodes;
        pairs.forEach(p -> this.locParts.computeIfAbsent(p.getGroupId(), k -> new HashSet()).add(p.getPartitionId()));
    }

    public UUID requestId() {
        return this.rqId;
    }

    public String snapshotName() {
        return this.snpName;
    }

    public String consistentId() {
        return this.consId;
    }

    public String folderName() {
        return this.folderName;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public List<Integer> cacheGroupIds() {
        return this.grpIds;
    }

    public Set<String> baselineNodes() {
        return this.bltNodes;
    }

    public Map<Integer, Set<Integer>> partitions() {
        return this.locParts;
    }

    public boolean sameSnapshot(SnapshotMetadata compare) {
        return this.requestId().equals(compare.requestId()) && this.snapshotName().equals(compare.snapshotName()) && this.pageSize() == compare.pageSize() && Objects.equals(this.cacheGroupIds(), compare.cacheGroupIds()) && Objects.equals(this.baselineNodes(), compare.baselineNodes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotMetadata meta = (SnapshotMetadata)o;
        return this.rqId.equals(meta.rqId) && this.snpName.equals(meta.snpName) && this.consId.equals(meta.consId) && Objects.equals(this.grpIds, meta.grpIds) && Objects.equals(this.bltNodes, meta.bltNodes);
    }

    public int hashCode() {
        return Objects.hash(this.rqId, this.snpName, this.consId, this.grpIds, this.bltNodes);
    }

    public String toString() {
        return S.toString(SnapshotMetadata.class, this);
    }
}

