/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.AbstractTimestampIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.pagemem.PageUtils;

public class TimestampInlineIndexKeyType
extends NullableInlineIndexKeyType<AbstractTimestampIndexKey> {
    public TimestampInlineIndexKeyType() {
        super(11, (short)16);
    }

    @Override
    public int compare0(long pageAddr, int off, AbstractTimestampIndexKey key) {
        long val1 = PageUtils.getLong(pageAddr, off + 1);
        int c = Long.compare(val1, key.dateValue());
        if (c != 0) {
            return Integer.signum(c);
        }
        long nanos1 = PageUtils.getLong(pageAddr, off + 9);
        return Integer.signum(Long.compare(nanos1, key.nanos()));
    }

    @Override
    protected int put0(long pageAddr, int off, AbstractTimestampIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type());
        PageUtils.putLong(pageAddr, off + 1, key.dateValue());
        PageUtils.putLong(pageAddr, off + 9, key.nanos());
        return this.keySize + 1;
    }

    @Override
    protected AbstractTimestampIndexKey get0(long pageAddr, int off) {
        long dv = PageUtils.getLong(pageAddr, off + 1);
        long nanos = PageUtils.getLong(pageAddr, off + 9);
        if (dv > 511999999903L) {
            dv = 511999999903L;
            nanos = 86399999999999L;
        } else if (dv < -511999999455L) {
            dv = -511999999455L;
            nanos = 0L;
        }
        return (AbstractTimestampIndexKey)IndexKeyFactory.wrapDateValue(this.type(), dv, nanos);
    }

    @Override
    protected int inlineSize0(AbstractTimestampIndexKey key) {
        return this.keySize + 1;
    }
}

