/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class SqlSystemViewBaselineNodes
extends SqlAbstractLocalSystemView {
    public SqlSystemViewBaselineNodes(GridKernalContext ctx) {
        super("BASELINE_NODES", "Baseline topology nodes", ctx, SqlSystemViewBaselineNodes.newColumn("CONSISTENT_ID"), SqlSystemViewBaselineNodes.newColumn("ONLINE", 1));
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        ArrayList<Row> rows = new ArrayList<Row>();
        BaselineTopology blt = this.ctx.state().clusterState().baselineTopology();
        if (blt == null) {
            return rows.iterator();
        }
        Set consistentIds = blt.consistentIds();
        Collection srvNodes = this.ctx.discovery().aliveServerNodes();
        HashSet aliveNodeIds = new HashSet(F.nodeConsistentIds((Collection)srvNodes));
        for (Object consistentId : consistentIds) {
            rows.add(this.createRow(ses, SqlSystemViewBaselineNodes.toStringSafe(consistentId), aliveNodeIds.contains(consistentId)));
        }
        return rows.iterator();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        BaselineTopology blt = this.ctx.state().clusterState().baselineTopology();
        return blt == null ? 0L : (long)blt.consistentIds().size();
    }
}

