/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.kubernetes;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.ignite.internal.kubernetes.connection.KubernetesServiceAddressResolver;
import org.apache.ignite.kubernetes.configuration.KubernetesConnectionConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;

public class TcpDiscoveryKubernetesIpFinder
extends TcpDiscoveryIpFinderAdapter {
    private final KubernetesConnectionConfiguration cfg;

    public TcpDiscoveryKubernetesIpFinder() {
        this(new KubernetesConnectionConfiguration());
    }

    public TcpDiscoveryKubernetesIpFinder(KubernetesConnectionConfiguration cfg) {
        this.setShared(true);
        this.cfg = cfg;
    }

    public Collection<InetSocketAddress> getRegisteredAddresses() throws IgniteSpiException {
        try {
            return new KubernetesServiceAddressResolver(this.cfg).getServiceAddresses().stream().map(addr -> new InetSocketAddress((InetAddress)addr, 0)).collect(Collectors.toCollection(ArrayList::new));
        }
        catch (Exception e) {
            throw new IgniteSpiException((Throwable)e);
        }
    }

    public void registerAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
    }

    public void unregisterAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
    }

    @Deprecated
    public void setServiceName(String service) {
        this.cfg.setServiceName(service);
    }

    @Deprecated
    public void setNamespace(String namespace) {
        this.cfg.setNamespace(namespace);
    }

    @Deprecated
    public void setMasterUrl(String master) {
        this.cfg.setMasterUrl(master);
    }

    @Deprecated
    public void setAccountToken(String accountToken) {
        this.cfg.setAccountToken(accountToken);
    }

    @Deprecated
    public void includeNotReadyAddresses(boolean includeNotReadyAddresses) {
        this.cfg.setIncludeNotReadyAddresses(includeNotReadyAddresses);
    }
}

