/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.meta.subcommands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.meta.MetadataCommand;
import org.apache.ignite.internal.commandline.meta.MetadataSubCommandsList;
import org.apache.ignite.internal.commandline.meta.subcommands.MetadataAbstractSubCommand;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataInfoTask;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataListResult;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataTypeArgs;
import org.apache.ignite.internal.util.typedef.F;

public class MetadataDetailsCommand
extends MetadataAbstractSubCommand<MetadataTypeArgs, MetadataListResult> {
    @Override
    protected String taskName() {
        return MetadataInfoTask.class.getName();
    }

    @Override
    public MetadataTypeArgs parseArguments0(CommandArgIterator argIter) {
        return MetadataCommand.parseArgs(argIter);
    }

    @Override
    protected void printResult(MetadataListResult res, Logger log) {
        if (res.metadata() == null) {
            log.info("Type not found");
            return;
        }
        assert (res.metadata().size() == 1) : "Unexpected  metadata results: " + res.metadata();
        BinaryMetadata m = (BinaryMetadata)F.first((Iterable)res.metadata());
        log.info("typeId=" + this.printInt(m.typeId()));
        log.info("typeName=" + m.typeName());
        log.info("Fields:");
        HashMap fldMap = new HashMap();
        m.fieldsMap().forEach((name, fldMeta) -> {
            log.info("  name=" + name + ", type=" + BinaryUtils.fieldTypeName((int)fldMeta.typeId()) + ", fieldId=" + this.printInt(fldMeta.fieldId()));
            fldMap.put(fldMeta.fieldId(), name);
        });
        log.info("Schemas:");
        m.schemas().forEach(s -> log.info("  schemaId=" + this.printInt(s.schemaId()) + ", fields=" + Arrays.stream(s.fieldIds()).mapToObj(fldMap::get).collect(Collectors.toList())));
    }

    @Override
    public String name() {
        return MetadataSubCommandsList.LIST.text();
    }
}

