/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.http.jetty;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryFieldMetadata;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryUtils;

public class IgniteBinaryObjectJsonDeserializer
extends JsonDeserializer<BinaryObject> {
    public static final String BINARY_TYPE_PROPERTY = "binaryTypeName";
    public static final String CACHE_NAME_PROPERTY = "cacheName";
    private final GridKernalContext ctx;

    public IgniteBinaryObjectJsonDeserializer(GridKernalContext ctx) {
        assert (ctx != null);
        this.ctx = ctx;
    }

    public BinaryObject deserialize(JsonParser parser, DeserializationContext dCtx) throws IOException {
        String type = (String)dCtx.findInjectableValue((Object)BINARY_TYPE_PROPERTY, null, null);
        String cacheName = (String)dCtx.findInjectableValue((Object)CACHE_NAME_PROPERTY, null, null);
        assert (type != null);
        JsonNode tree = (JsonNode)parser.readValueAsTree();
        ObjectCodec mapper = parser.getCodec();
        Map<String, BinaryFieldMetadata> binFields = this.binaryFields(type);
        Map<String, Class<?>> qryFields = this.queryFields(cacheName, type);
        BinaryObjectBuilder builder = this.ctx.cacheObjects().builder(type);
        Iterator itr = tree.fields();
        while (itr.hasNext()) {
            Class<Object> fieldCls;
            Map.Entry entry = (Map.Entry)itr.next();
            String field = (String)entry.getKey();
            JsonNode node = (JsonNode)entry.getValue();
            BinaryFieldMetadata meta = binFields.get(field);
            Class<Object> clazz = fieldCls = meta != null ? (Class<Object>)BinaryUtils.FLAG_TO_CLASS.get((byte)meta.typeId()) : null;
            if (fieldCls == null) {
                fieldCls = qryFields.getOrDefault(QueryUtils.normalizeObjectName((String)field, (boolean)true), Object.class);
            }
            builder.setField(field, mapper.treeToValue((TreeNode)node, (Class)fieldCls));
        }
        return builder.build();
    }

    private Map<String, Class<?>> queryFields(String cacheName, String type) {
        GridQueryTypeDescriptor desc;
        if (this.ctx.query().moduleEnabled() && (desc = this.ctx.query().typeDescriptor(cacheName, type)) != null) {
            return desc.fields();
        }
        return Collections.emptyMap();
    }

    private Map<String, BinaryFieldMetadata> binaryFields(String type) {
        BinaryTypeImpl binType = (BinaryTypeImpl)this.ctx.cacheObjects().binary().type(type);
        if (binType != null) {
            return binType.metadata().fieldsMap();
        }
        return Collections.emptyMap();
    }
}

