/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric.sql;

import java.util.function.Predicate;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.metric.sql.MetricRegistryLocalSystemView;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.ReadOnlyMetricManager;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.jetbrains.annotations.Nullable;

class SqlViewMetricExporterSpi
extends IgniteSpiAdapter
implements MetricExporterSpi {
    public static final String SYS_VIEW_NAME = "METRICS";
    private ReadOnlyMetricManager mreg;

    SqlViewMetricExporterSpi() {
    }

    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        GridKernalContext ctx = ((IgniteEx)this.ignite()).context();
        if (!(ctx.query().getIndexing() instanceof IgniteH2Indexing)) {
            return;
        }
        SchemaManager mgr = ((IgniteH2Indexing)ctx.query().getIndexing()).schemaManager();
        mgr.createSystemView(QueryUtils.SCHEMA_SYS, new MetricRegistryLocalSystemView(ctx, this.mreg));
        if (this.log.isDebugEnabled()) {
            this.log.debug("METRICS SQL view for metrics created.");
        }
    }

    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
    }

    public void spiStop() throws IgniteSpiException {
    }

    public void setMetricRegistry(ReadOnlyMetricManager mreg) {
        this.mreg = mreg;
    }

    public void setExportFilter(Predicate<ReadOnlyMetricRegistry> filter) {
    }
}

