/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.failover;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.yardstick.cache.failover.IgniteConsistencyException;
import org.apache.ignite.yardstick.cache.failover.IgniteFailoverAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteTransactionalInvokeRetryBenchmark
extends IgniteFailoverAbstractBenchmark<String, Long> {
    private final ConcurrentMap<String, AtomicLong> map = new ConcurrentHashMap<String, AtomicLong>();
    private final ReadWriteLock rwl = new ReentrantReadWriteLock(true);
    private volatile Exception ex;

    @Override
    public void setUp(final BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block14: {
                    try {
                        int timeout = IgniteTransactionalInvokeRetryBenchmark.this.args.cacheOperationTimeoutMillis();
                        int keysCnt = IgniteTransactionalInvokeRetryBenchmark.this.args.keysCount();
                        while (!Thread.currentThread().isInterrupted()) {
                            Thread.sleep(IgniteTransactionalInvokeRetryBenchmark.this.args.cacheConsistencyCheckingPeriod() * 1000);
                            IgniteTransactionalInvokeRetryBenchmark.this.rwl.writeLock().lock();
                            try {
                                String key;
                                BenchmarkUtils.println((String)"Start cache validation.");
                                long startTime = U.currentTimeMillis();
                                HashMap<String, Long> notEqualsCacheVals = new HashMap<String, Long>();
                                HashMap<String, Long> notEqualsLocMapVals = new HashMap<String, Long>();
                                for (int k = 0; k < IgniteTransactionalInvokeRetryBenchmark.this.args.range(); ++k) {
                                    if (k % 10000 == 0) {
                                        BenchmarkUtils.println((String)("Start validation for keys like 'key-" + k + "-*'"));
                                    }
                                    for (int i = 0; i < keysCnt; ++i) {
                                        Long mapVal;
                                        key = "key-" + k + "-" + cfg.memberId() + "-" + i;
                                        Long cacheVal = (Long)IgniteTransactionalInvokeRetryBenchmark.this.cache.getAsync((Object)key).get((long)timeout);
                                        AtomicLong aVal = (AtomicLong)IgniteTransactionalInvokeRetryBenchmark.this.map.get(key);
                                        Long l = mapVal = aVal != null ? Long.valueOf(aVal.get()) : null;
                                        if (Objects.equals(cacheVal, mapVal)) continue;
                                        notEqualsCacheVals.put(key, cacheVal);
                                        notEqualsLocMapVals.put(key, mapVal);
                                    }
                                }
                                assert (notEqualsCacheVals.size() == notEqualsLocMapVals.size()) : "Invalid state [cacheMapVals=" + notEqualsCacheVals + ", mapVals=" + notEqualsLocMapVals + "]";
                                if (!notEqualsCacheVals.isEmpty()) {
                                    for (Map.Entry eLocMap : notEqualsLocMapVals.entrySet()) {
                                        key = (String)eLocMap.getKey();
                                        Long mapVal = (Long)eLocMap.getValue();
                                        Long cacheVal = (Long)notEqualsCacheVals.get(key);
                                        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Got different values [key='" + key + "', cacheVal=" + cacheVal + ", localMapVal=" + mapVal + "]"));
                                    }
                                    BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Local driver map contant:\n " + IgniteTransactionalInvokeRetryBenchmark.this.map));
                                    BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Cache content:");
                                    for (int k2 = 0; k2 < IgniteTransactionalInvokeRetryBenchmark.this.args.range(); ++k2) {
                                        for (int i2 = 0; i2 < keysCnt; ++i2) {
                                            String key2 = "key-" + k2 + "-" + cfg.memberId() + "-" + i2;
                                            Long val = (Long)IgniteTransactionalInvokeRetryBenchmark.this.cache.getAsync((Object)key2).get((long)timeout);
                                            if (val == null) continue;
                                            BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Entry [key=" + key2 + ", val=" + val + "]"));
                                        }
                                    }
                                    throw new IgniteConsistencyException("Cache and local map are in inconsistent state.");
                                }
                                BenchmarkUtils.println((String)("Cache validation successfully finished in " + (U.currentTimeMillis() - startTime) / 1000L + " sec."));
                            }
                            finally {
                                IgniteTransactionalInvokeRetryBenchmark.this.rwl.writeLock().unlock();
                            }
                        }
                    }
                    catch (Throwable e) {
                        IgniteTransactionalInvokeRetryBenchmark.this.ex = new Exception(e);
                        BenchmarkUtils.println((String)("Got exception: " + e));
                        e.printStackTrace();
                        if (!(e instanceof Error)) break block14;
                        throw (Error)e;
                    }
                }
            }
        }, "cache-" + this.cacheName() + "-validator");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test(Map<Object, Object> ctx) throws Exception {
        int k = IgniteTransactionalInvokeRetryBenchmark.nextRandom(this.args.range());
        String[] keys = new String[this.args.keysCount()];
        assert (keys.length > 0) : "Count of keys: " + keys.length;
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = "key-" + k + "-" + this.cfg.memberId() + "-" + i;
        }
        for (String key : keys) {
            this.rwl.readLock().lock();
            try {
                if (this.ex != null) {
                    throw this.ex;
                }
                this.cache.invokeAsync((Object)key, (CacheEntryProcessor)new IncrementInvokeRetryCacheEntryProcessor(), new Object[0]).get((long)this.args.cacheOperationTimeoutMillis());
                AtomicLong prevVal = this.map.putIfAbsent(key, new AtomicLong(0L));
                if (prevVal == null) continue;
                prevVal.incrementAndGet();
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }
        if (this.ex != null) {
            throw this.ex;
        }
        return true;
    }

    @Override
    protected String cacheName() {
        return "tx-invoke-retry";
    }

    private static class IncrementInvokeRetryCacheEntryProcessor
    implements CacheEntryProcessor<String, Long, Long> {
        private static final long serialVersionUID = 0L;

        private IncrementInvokeRetryCacheEntryProcessor() {
        }

        public Long process(MutableEntry<String, Long> entry, Object ... arguments) throws EntryProcessorException {
            long newVal = entry.getValue() == null ? 0L : (Long)entry.getValue() + 1L;
            entry.setValue((Object)newVal);
            return newVal;
        }
    }
}

