/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.IgniteBenchmarkUtils;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.WaitMapExchangeFinishCallable;
import org.apache.ignite.yardstick.cache.model.SampleValue;
import org.yardstickframework.BenchmarkConfiguration;

public class IgnitePutTxBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private IgniteTransactions txs;
    private Callable<Void> clo;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        if (!IgniteSystemProperties.getBoolean((String)"SKIP_MAP_CHECK")) {
            this.ignite().compute().broadcast((IgniteCallable)new WaitMapExchangeFinishCallable());
        }
        this.txs = this.ignite().transactions();
        this.clo = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                IgniteCache cache = IgnitePutTxBenchmark.this.cacheForOperation();
                int key = IgniteAbstractBenchmark.nextRandom(IgnitePutTxBenchmark.this.args.range());
                cache.put((Object)key, (Object)new SampleValue(key));
                return null;
            }
        };
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        IgniteBenchmarkUtils.doInTransaction(this.txs, this.args.txConcurrency(), this.args.txIsolation(), this.clo);
        return true;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("tx");
    }
}

