/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.ignite.internal.util.io.GridUnsafeDataInput;
import org.apache.ignite.internal.util.io.GridUnsafeDataOutput;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridByteArrayList
implements Message,
Externalizable {
    private static final long serialVersionUID = 0L;
    @GridToStringExclude
    private byte[] data;
    private int size;

    public GridByteArrayList() {
    }

    public GridByteArrayList(int cap) {
        assert (cap > 0);
        this.data = new byte[cap];
    }

    public GridByteArrayList(byte[] data, int size) {
        assert (data != null);
        assert (size > 0);
        this.data = data;
        this.size = size;
    }

    public GridByteArrayList(byte[] data) {
        assert (data != null);
        this.data = data;
        this.size = data.length;
    }

    public void reset() {
        this.size = 0;
    }

    public byte[] internalArray() {
        return this.data;
    }

    public byte[] array() {
        byte[] res = new byte[this.size];
        U.arrayCopy(this.data, 0, res, 0, this.size);
        return res;
    }

    public byte[] entireArray() {
        return this.size == this.data.length ? this.internalArray() : this.array();
    }

    public int capacity() {
        return this.data.length;
    }

    private void capacity(int cap) {
        assert (cap > 0);
        if (cap != this.capacity()) {
            if (cap < this.size) {
                this.size = cap;
                return;
            }
            this.data = Arrays.copyOf(this.data, cap);
        }
    }

    public int size() {
        return this.size;
    }

    public void allocate(int cnt) {
        if (this.size + cnt > this.capacity()) {
            this.capacity(this.size + cnt);
        }
    }

    private void requestFreeSize(int cnt) {
        if (this.size + cnt > this.capacity()) {
            this.capacity(this.size + cnt << 1);
        }
    }

    public void add(byte b) {
        this.requestFreeSize(1);
        this.data[this.size++] = b;
    }

    public void set(int pos, byte b) {
        assert (pos >= 0);
        assert (pos < this.size);
        this.data[pos] = b;
    }

    public void add(int i) {
        this.requestFreeSize(4);
        U.intToBytes(i, this.data, this.size);
        this.size += 4;
    }

    public void add(short i) {
        this.requestFreeSize(2);
        U.shortToBytes(i, this.data, this.size);
        this.size += 2;
    }

    public void set(int pos, short i) {
        assert (pos >= 0);
        assert (pos + 2 <= this.size);
        U.shortToBytes(i, this.data, pos);
    }

    public void set(int pos, int i) {
        assert (pos >= 0);
        assert (pos + 4 <= this.size);
        U.intToBytes(i, this.data, pos);
    }

    public void add(long l) {
        this.requestFreeSize(8);
        U.longToBytes(l, this.data, this.size);
        this.size += 8;
    }

    public void set(int pos, long l) {
        assert (pos >= 0);
        assert (pos + 8 <= this.size);
        U.longToBytes(l, this.data, pos);
    }

    public void add(byte[] bytes, int off, int len) {
        this.requestFreeSize(len);
        U.arrayCopy(bytes, off, this.data, this.size, len);
        this.size += len;
    }

    public void add(ByteBuffer buf, int len) {
        this.requestFreeSize(len);
        buf.get(this.data, this.size, len);
        this.size += len;
    }

    public byte get(int i) {
        assert (i < this.size);
        return this.data[i];
    }

    public int getInt(int i) {
        assert (i + 4 <= this.size);
        return U.bytesToInt(this.data, i);
    }

    public void readAll(InputStream in) throws IOException {
        assert (in != null);
        int read = 0;
        while (read >= 0) {
            int free = this.capacity() - this.size;
            if (free == 0) {
                this.requestFreeSize(1);
                free = this.capacity() - this.size;
                assert (free > 0);
            }
            if ((read = in.read(this.data, this.size, free)) <= 0) continue;
            this.size += read;
        }
    }

    public OutputStream outputStream() {
        GridUnsafeDataOutput out = new GridUnsafeDataOutput();
        out.bytes(this.data, this.size);
        return out;
    }

    public InputStream inputStream() {
        GridUnsafeDataInput in = new GridUnsafeDataInput();
        in.bytes(this.data, this.size);
        return in;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.write(this.data, 0, this.size);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.data = new byte[this.size];
        in.readFully(this.data, 0, this.size);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("data", this.data)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeInt("size", this.size)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.data = reader.readByteArray("data");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.size = reader.readInt("size");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridByteArrayList.class);
    }

    @Override
    public short directType() {
        return 84;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        return S.toString(GridByteArrayList.class, this);
    }
}

