/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.metastorage;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.MetastoreDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRecord;
import org.apache.ignite.internal.processors.cache.CacheDiagnosticManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageDataRow;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageRowStore;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageRowStoreEntry;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageTree;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.partstorage.PartitionMetaStorageImpl;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.jetbrains.annotations.NotNull;

public class MetaStorage
implements CheckpointListener,
ReadWriteMetastorage {
    public static final String METASTORAGE_CACHE_NAME = "MetaStorage";
    public static final int METASTORAGE_CACHE_ID = CU.cacheId("MetaStorage");
    public static final String METASTORAGE_DIR_NAME = "metastorage";
    public static final int OLD_METASTORE_PARTITION = 0;
    public static final int METASTORE_PARTITION = 1;
    public static final Set<Integer> METASTORAGE_PARTITIONS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(0, 1)));
    public static boolean PRESERVE_LEGACY_METASTORAGE_PARTITION_ID = false;
    private static final byte[] TOMBSTONE = new byte[0];
    private static final int TEMPORARY_METASTORAGE_IN_MEMORY_SIZE = 0x8000000;
    private static final int TEMPORARY_METASTORAGE_BUFFER_SIZE = 0x100000;
    private final IgniteWriteAheadLogManager wal;
    private final DataRegion dataRegion;
    private final IgniteLogger log;
    private MetastorageTree tree;
    private AtomicLong rmvId = new AtomicLong();
    private final boolean readOnly;
    private boolean empty;
    private RootPage treeRoot;
    private RootPage reuseListRoot;
    private PartitionMetaStorageImpl<MetastorageRowStoreEntry> partStorage;
    private SortedMap<String, byte[]> lastUpdates;
    private final Marshaller marshaller = JdkMarshaller.DEFAULT;
    private final FailureProcessor failureProcessor;
    private int partId;
    private final GridCacheSharedContext cctx;

    public MetaStorage(GridCacheSharedContext<?, ?> cctx, DataRegion dataRegion, boolean readOnly) {
        this.cctx = cctx;
        this.wal = cctx.wal();
        this.dataRegion = dataRegion;
        this.readOnly = readOnly;
        this.log = cctx.logger(this.getClass());
        this.failureProcessor = cctx.kernalContext().failure();
    }

    public void init(final GridCacheDatabaseSharedManager db) throws IgniteCheckedException {
        this.dataRegion.metrics().clear();
        this.initInternal(db);
        if (!PRESERVE_LEGACY_METASTORAGE_PARTITION_ID) {
            if (this.partId == 0) {
                db.temporaryMetaStorage(this.copyDataToTmpStorage());
            } else if (db.temporaryMetaStorage() != null) {
                this.restoreDataFromTmpStorage(db.temporaryMetaStorage());
                db.temporaryMetaStorage(null);
                db.addCheckpointListener(new CheckpointListener(){

                    @Override
                    public void onMarkCheckpointBegin(CheckpointListener.Context ctx) {
                    }

                    @Override
                    public void onCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
                        assert (MetaStorage.this.cctx.pageStore() != null);
                        int partTag = ((PageMemoryEx)MetaStorage.this.dataRegion.pageMemory()).invalidate(METASTORAGE_CACHE_ID, 0);
                        MetaStorage.this.cctx.pageStore().onPartitionDestroyed(METASTORAGE_CACHE_ID, 0, partTag);
                        int idxTag = ((PageMemoryEx)MetaStorage.this.dataRegion.pageMemory()).invalidate(METASTORAGE_CACHE_ID, 65535);
                        PageStore store = ((FilePageStoreManager)MetaStorage.this.cctx.pageStore()).getStore(METASTORAGE_CACHE_ID, 65535);
                        store.truncate(idxTag);
                        db.removeCheckpointListener(this);
                    }

                    @Override
                    public void beforeCheckpointBegin(CheckpointListener.Context ctx) {
                    }
                }, this.dataRegion);
            }
        }
    }

    private TmpStorage copyDataToTmpStorage() throws IgniteCheckedException {
        TmpStorage tmpStorage = new TmpStorage(0x8000000, this.log);
        GridCursor cur = this.tree.find(null, null);
        while (cur.next()) {
            MetastorageDataRow row = (MetastorageDataRow)cur.get();
            tmpStorage.add(row.key(), this.partStorage.readRow(row.link()));
        }
        return tmpStorage;
    }

    private void restoreDataFromTmpStorage(TmpStorage tmpStorage) throws IgniteCheckedException {
        Iterator it = tmpStorage.stream().iterator();
        while (it.hasNext()) {
            IgniteBiTuple t = (IgniteBiTuple)it.next();
            this.writeRaw((String)t.get1(), (byte[])t.get2());
        }
        try {
            tmpStorage.close();
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), e);
        }
    }

    private void initInternal(IgniteCacheDatabaseSharedManager db) throws IgniteCheckedException {
        block6: {
            block7: {
                block5: {
                    if (!PRESERVE_LEGACY_METASTORAGE_PARTITION_ID) break block5;
                    this.partId = 0;
                    this.getOrAllocateMetas(0);
                    break block6;
                }
                if (!this.readOnly) break block7;
                this.partId = 0;
                if (!this.getOrAllocateMetas(0)) break block6;
            }
            this.partId = 1;
            this.getOrAllocateMetas(1);
        }
        if (!this.empty) {
            CacheDiagnosticManager diagnosticMgr = this.cctx.diagnostic();
            String freeListName = "MetaStorage##FreeList";
            String treeName = "MetaStorage##Tree";
            this.partStorage = new PartitionMetaStorageImpl<MetastorageRowStoreEntry>(METASTORAGE_CACHE_ID, freeListName, this.dataRegion, null, this.wal, this.reuseListRoot.pageId().pageId(), this.reuseListRoot.isAllocated(), diagnosticMgr.pageLockTracker().createPageLockTracker(freeListName), this.cctx.kernalContext(), null, 4){

                @Override
                protected long allocatePageNoReuse() throws IgniteCheckedException {
                    return this.pageMem.allocatePage(this.grpId, MetaStorage.this.partId, (byte)4);
                }
            };
            MetastorageRowStore rowStore = new MetastorageRowStore(this.partStorage, db);
            this.tree = new MetastorageTree(METASTORAGE_CACHE_ID, treeName, this.dataRegion.pageMemory(), this.wal, this.rmvId, this.partStorage, rowStore, this.treeRoot.pageId().pageId(), this.treeRoot.isAllocated(), this.failureProcessor, this.partId, diagnosticMgr.pageLockTracker().createPageLockTracker(treeName));
            if (!this.readOnly) {
                ((GridCacheDatabaseSharedManager)db).addCheckpointListener(this, this.dataRegion);
            }
        }
    }

    @Override
    public Serializable read(String key) throws IgniteCheckedException {
        byte[] data = this.readRaw(key);
        Serializable res = null;
        if (data != null) {
            res = (Serializable)this.marshaller.unmarshal(data, U.gridClassLoader());
        }
        return res;
    }

    @Override
    public void iterate(String keyPrefix, BiConsumer<String, ? super Serializable> cb, boolean unmarshal) throws IgniteCheckedException {
        SortedMap<String, byte[]> prefixedSubmap;
        if (this.empty) {
            return;
        }
        Iterator<Map.Entry<String, byte[]>> updatesIter = null;
        if (this.readOnly && this.lastUpdates != null && !(prefixedSubmap = this.lastUpdates.subMap(keyPrefix, keyPrefix + "\uffff")).isEmpty()) {
            updatesIter = prefixedSubmap.entrySet().iterator();
        }
        Map.Entry<String, byte[]> curUpdatesEntry = null;
        if (updatesIter != null) {
            assert (updatesIter.hasNext());
            curUpdatesEntry = (Map.Entry<String, byte[]>)updatesIter.next();
        }
        MetastorageSearchRow lower = new MetastorageSearchRow(keyPrefix);
        MetastorageSearchRow upper = new MetastorageSearchRow(keyPrefix + "\uffff");
        GridCursor cur = this.tree.find(lower, upper);
        while (cur.next()) {
            MetastorageDataRow row = (MetastorageDataRow)cur.get();
            String key = row.key();
            byte[] valBytes = this.partStorage.readRow(row.link());
            int c = 0;
            while (curUpdatesEntry != null && (c = curUpdatesEntry.getKey().compareTo(key)) < 0) {
                curUpdatesEntry = this.advanceCurrentUpdatesEntry(cb, unmarshal, updatesIter, curUpdatesEntry);
            }
            if (curUpdatesEntry != null && c == 0) {
                curUpdatesEntry = this.advanceCurrentUpdatesEntry(cb, unmarshal, updatesIter, curUpdatesEntry);
                continue;
            }
            this.applyCallback(cb, unmarshal, key, valBytes);
        }
        while (curUpdatesEntry != null) {
            curUpdatesEntry = this.advanceCurrentUpdatesEntry(cb, unmarshal, updatesIter, curUpdatesEntry);
        }
    }

    private Map.Entry<String, byte[]> advanceCurrentUpdatesEntry(BiConsumer<String, ? super Serializable> cb, boolean unmarshal, Iterator<Map.Entry<String, byte[]>> updatesIter, Map.Entry<String, byte[]> curUpdatesEntry) throws IgniteCheckedException {
        this.applyCallback(cb, unmarshal, curUpdatesEntry.getKey(), curUpdatesEntry.getValue());
        return updatesIter.hasNext() ? updatesIter.next() : null;
    }

    private void applyCallback(BiConsumer<String, ? super Serializable> cb, boolean unmarshal, String key, byte[] valBytes) throws IgniteCheckedException {
        if (valBytes != TOMBSTONE) {
            if (unmarshal) {
                Serializable val = (Serializable)this.marshaller.unmarshal(valBytes, U.gridClassLoader());
                cb.accept(key, val);
            } else {
                cb.accept(key, (Serializable)valBytes);
            }
        }
    }

    @Override
    public void write(@NotNull String key, @NotNull Serializable val) throws IgniteCheckedException {
        assert (val != null);
        if (!this.readOnly) {
            this.writeRaw(key, this.marshaller.marshal(val));
        }
    }

    @Override
    public void remove(@NotNull String key) throws IgniteCheckedException {
        this.removeData(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRaw(String key, byte[] data) throws IgniteCheckedException {
        if (!this.readOnly) {
            WALPointer ptr;
            MetaStorage metaStorage = this;
            synchronized (metaStorage) {
                ptr = this.wal.log(new MetastoreDataRecord(key, data));
                MetastorageDataRow oldRow = (MetastorageDataRow)this.tree.findOne(new MetastorageSearchRow(key));
                byte[] keyBytes = key.getBytes();
                long keyLink = oldRow != null ? oldRow.keyLink() : (keyBytes.length > 64 ? this.tree.rowStore().addRow(keyBytes) : 0L);
                long dataLink = this.tree.rowStore().addRow(data);
                this.tree.put(new MetastorageDataRow(dataLink, key, keyLink));
                if (oldRow != null) {
                    this.tree.rowStore().removeRow(oldRow.link());
                }
            }
            this.wal.flush(ptr, false);
        }
    }

    @Override
    public byte[] readRaw(String key) throws IgniteCheckedException {
        MetastorageDataRow row;
        if (this.readOnly) {
            byte[] res;
            if (this.lastUpdates != null && (res = (byte[])this.lastUpdates.get(key)) != null) {
                return (byte[])(res != TOMBSTONE ? res : null);
            }
            if (this.empty) {
                return null;
            }
        }
        if ((row = (MetastorageDataRow)this.tree.findOne(new MetastorageSearchRow(key))) == null) {
            return null;
        }
        return this.partStorage.readRow(row.link());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(String key) throws IgniteCheckedException {
        if (!this.readOnly) {
            WALPointer ptr;
            MetaStorage metaStorage = this;
            synchronized (metaStorage) {
                MetastorageDataRow oldRow = (MetastorageDataRow)this.tree.findOne(new MetastorageSearchRow(key));
                if (oldRow == null) {
                    return;
                }
                ptr = this.wal.log(new MetastoreDataRecord(key, null));
                this.tree.removex(oldRow);
                this.tree.rowStore().removeRow(oldRow.link());
                if (oldRow.keyLink() != 0L) {
                    this.tree.rowStore().removeRow(oldRow.keyLink());
                }
            }
            this.wal.flush(ptr, false);
        }
    }

    private void checkRootsPageIdFlag(long treeRoot, long reuseListRoot) throws StorageException {
        if (PageIdUtils.flag(treeRoot) != 4 && PageIdUtils.flag(treeRoot) != 1) {
            throw new StorageException("Wrong tree root page id flag: treeRoot=" + U.hexLong(treeRoot) + ", METASTORAGE_CACHE_ID=" + METASTORAGE_CACHE_ID);
        }
        if (PageIdUtils.flag(reuseListRoot) != 4 && PageIdUtils.flag(reuseListRoot) != 1) {
            throw new StorageException("Wrong reuse list root page id flag: reuseListRoot=" + U.hexLong(reuseListRoot) + ", METASTORAGE_CACHE_ID=" + METASTORAGE_CACHE_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getOrAllocateMetas(int partId) throws IgniteCheckedException {
        block19: {
            this.empty = false;
            PageMemoryEx pageMem = (PageMemoryEx)this.dataRegion.pageMemory();
            long partMetaId = pageMem.partitionMetaPageId(METASTORAGE_CACHE_ID, partId);
            long partMetaPage = pageMem.acquirePage(METASTORAGE_CACHE_ID, partMetaId);
            try {
                if (this.readOnly) {
                    long pageAddr = pageMem.readLock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
                    try {
                        if (PageIO.getType(pageAddr) != 14) {
                            this.empty = true;
                            boolean bl = true;
                            return bl;
                        }
                        PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(pageAddr);
                        long treeRoot = io.getTreeRoot(pageAddr);
                        long reuseListRoot = io.getReuseListRoot(pageAddr);
                        this.checkRootsPageIdFlag(treeRoot, reuseListRoot);
                        this.treeRoot = new RootPage(new FullPageId(treeRoot, METASTORAGE_CACHE_ID), false);
                        this.reuseListRoot = new RootPage(new FullPageId(reuseListRoot, METASTORAGE_CACHE_ID), false);
                        this.rmvId.set(io.getGlobalRemoveId(pageAddr));
                        break block19;
                    }
                    finally {
                        pageMem.readUnlock(METASTORAGE_CACHE_ID, partId, partMetaPage);
                    }
                }
                boolean allocated = false;
                long pageAddr = pageMem.writeLock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
                try {
                    long reuseListRoot;
                    long treeRoot;
                    if (PageIO.getType(pageAddr) != 14) {
                        PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.latest();
                        PageMetrics metrics = pageMem.metrics().cacheGrpPageMetrics(METASTORAGE_CACHE_ID);
                        io.initNewPage(pageAddr, partMetaId, pageMem.pageSize(), metrics);
                        treeRoot = pageMem.allocatePage(METASTORAGE_CACHE_ID, partId, (byte)4);
                        reuseListRoot = pageMem.allocatePage(METASTORAGE_CACHE_ID, partId, (byte)4);
                        assert (PageIdUtils.flag(treeRoot) == 4);
                        assert (PageIdUtils.flag(reuseListRoot) == 4);
                        io.setTreeRoot(pageAddr, treeRoot);
                        io.setReuseListRoot(pageAddr, reuseListRoot);
                        if (PageHandler.isWalDeltaRecordNeeded(pageMem, METASTORAGE_CACHE_ID, partMetaId, partMetaPage, this.wal, null)) {
                            assert (io.getType() == 14);
                            this.wal.log(new MetaPageInitRecord(METASTORAGE_CACHE_ID, partMetaId, io.getType(), io.getVersion(), treeRoot, reuseListRoot));
                        }
                        allocated = true;
                    } else {
                        PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(pageAddr);
                        treeRoot = io.getTreeRoot(pageAddr);
                        reuseListRoot = io.getReuseListRoot(pageAddr);
                        this.rmvId.set(io.getGlobalRemoveId(pageAddr));
                        this.checkRootsPageIdFlag(treeRoot, reuseListRoot);
                    }
                    this.treeRoot = new RootPage(new FullPageId(treeRoot, METASTORAGE_CACHE_ID), allocated);
                    this.reuseListRoot = new RootPage(new FullPageId(reuseListRoot, METASTORAGE_CACHE_ID), allocated);
                }
                finally {
                    pageMem.writeUnlock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage, null, allocated);
                }
            }
            finally {
                pageMem.releasePage(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
            }
        }
        return false;
    }

    public PageMemory pageMemory() {
        return this.dataRegion.pageMemory();
    }

    @Override
    public void onMarkCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
        Executor executor = ctx.executor();
        if (executor == null) {
            this.partStorage.saveMetadata(IoStatisticsHolderNoOp.INSTANCE);
            this.saveStoreMetadata();
        } else {
            executor.execute(() -> {
                try {
                    this.partStorage.saveMetadata(IoStatisticsHolderNoOp.INSTANCE);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            });
            executor.execute(() -> {
                try {
                    this.saveStoreMetadata();
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            });
        }
    }

    @Override
    public void beforeCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
        this.partStorage.saveMetadata(IoStatisticsHolderNoOp.INSTANCE);
    }

    @Override
    public void onCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStoreMetadata() throws IgniteCheckedException {
        PageMemoryEx pageMem = (PageMemoryEx)this.pageMemory();
        long partMetaId = pageMem.partitionMetaPageId(METASTORAGE_CACHE_ID, this.partId);
        long partMetaPage = pageMem.acquirePage(METASTORAGE_CACHE_ID, partMetaId);
        try {
            long partMetaPageAddr = pageMem.writeLock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
            if (partMetaPageAddr == 0L) {
                U.warn(this.log, "Failed to acquire write lock for meta page [metaPage=" + partMetaPage + ']');
                return;
            }
            boolean changed = false;
            try {
                PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(partMetaPageAddr);
                changed |= io.setGlobalRemoveId(partMetaPageAddr, this.rmvId.get());
            }
            finally {
                pageMem.writeUnlock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage, null, changed);
            }
        }
        finally {
            pageMem.releasePage(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
        }
    }

    public void applyUpdate(String key, byte[] value) throws IgniteCheckedException {
        if (this.readOnly) {
            if (this.lastUpdates == null) {
                this.lastUpdates = new TreeMap<String, byte[]>();
            }
            this.lastUpdates.put(key, value != null ? value : TOMBSTONE);
        } else if (value != null) {
            this.writeRaw(key, value);
        } else {
            this.removeData(key);
        }
    }

    public Marshaller marshaller() {
        return this.marshaller;
    }

    public static class TmpStorage
    implements Closeable {
        final List<TmpStorageInternal> chain = new ArrayList<TmpStorageInternal>(2);
        TmpStorageInternal current;
        final IgniteLogger log;

        TmpStorage(int memBufSize, IgniteLogger log) {
            this.log = log;
            this.current = new MemoryTmpStorage(memBufSize);
            this.chain.add(this.current);
        }

        public void add(String key, byte[] val) throws IgniteCheckedException {
            try {
                while (!this.current.add(key, val)) {
                    this.current = new FileTmpStorage();
                    this.chain.add(this.current);
                }
            }
            catch (IOException e) {
                throw new IgniteCheckedException(e);
            }
        }

        public Stream<IgniteBiTuple<String, byte[]>> stream() {
            return this.chain.stream().flatMap(storage -> {
                try {
                    return storage.stream();
                }
                catch (IOException e) {
                    throw new IgniteException(e);
                }
            });
        }

        @Override
        public void close() throws IOException {
            for (TmpStorageInternal storage : this.chain) {
                try {
                    storage.close();
                }
                catch (IOException ex) {
                    this.log.error(ex.getMessage(), ex);
                }
            }
        }
    }

    private static class FileTmpStorage
    implements TmpStorageInternal {
        final ByteBuffer cache = ByteBuffer.allocateDirect(0x100000);
        RandomAccessFile file;
        long size;

        private FileTmpStorage() {
        }

        @Override
        public boolean add(String key, byte[] val) throws IOException {
            byte[] keyData;
            if (this.file == null) {
                this.file = new RandomAccessFile(File.createTempFile("m_storage", "bin"), "rw");
            }
            if (val.length + (keyData = key.getBytes(StandardCharsets.UTF_8)).length + 8 > this.cache.remaining()) {
                this.flushCache(false);
            }
            this.cache.putInt(keyData.length).putInt(val.length).put(keyData).put(val);
            ++this.size;
            return true;
        }

        @Override
        public Stream<IgniteBiTuple<String, byte[]>> stream() throws IOException {
            if (this.file == null) {
                return Stream.empty();
            }
            this.flushCache(true);
            this.file.getChannel().position(0L);
            this.readToCache();
            return Stream.generate(() -> {
                if (this.cache.remaining() <= 8) {
                    this.cache.compact();
                    try {
                        this.readToCache();
                    }
                    catch (IOException e) {
                        throw new IgniteException(e);
                    }
                }
                int keyLen = this.cache.getInt();
                int dataLen = this.cache.getInt();
                if (this.cache.remaining() < keyLen + dataLen) {
                    this.cache.compact();
                    try {
                        this.readToCache();
                    }
                    catch (IOException e) {
                        throw new IgniteException(e);
                    }
                }
                byte[] tmpBuf = new byte[Math.max(keyLen, dataLen)];
                this.cache.get(tmpBuf, 0, keyLen);
                String key = new String(tmpBuf, 0, keyLen, StandardCharsets.UTF_8);
                this.cache.get(tmpBuf, 0, dataLen);
                return new IgniteBiTuple<String, byte[]>(key, tmpBuf.length > dataLen ? Arrays.copyOf(tmpBuf, dataLen) : tmpBuf);
            }).limit(this.size);
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }

        private void readToCache() throws IOException {
            for (int len = (int)Math.min(this.file.length() - this.file.getChannel().position(), (long)this.cache.remaining()); len > 0; len -= this.file.getChannel().read(this.cache)) {
            }
            this.cache.flip();
        }

        private void flushCache(boolean force) throws IOException {
            if (this.cache.position() > 0) {
                this.cache.flip();
                while (this.cache.remaining() > 0) {
                    this.file.getChannel().write(this.cache);
                }
                this.cache.clear();
            }
            this.file.getChannel().force(force);
        }
    }

    private static class MemoryTmpStorage
    implements TmpStorageInternal {
        final ByteBuffer buf;
        int size;

        MemoryTmpStorage(int size) {
            this.buf = ByteBuffer.allocateDirect(size);
        }

        @Override
        public boolean add(String key, byte[] val) {
            byte[] keyData = key.getBytes(StandardCharsets.UTF_8);
            if (val.length + keyData.length + 8 > this.buf.remaining()) {
                return false;
            }
            this.buf.putInt(keyData.length).putInt(val.length).put(keyData).put(val);
            ++this.size;
            return true;
        }

        @Override
        public Stream<IgniteBiTuple<String, byte[]>> stream() {
            this.buf.flip();
            return Stream.generate(() -> {
                int keyLen = this.buf.getInt();
                int dataLen = this.buf.getInt();
                byte[] tmpBuf = new byte[Math.max(keyLen, dataLen)];
                this.buf.get(tmpBuf, 0, keyLen);
                String key = new String(tmpBuf, 0, keyLen, StandardCharsets.UTF_8);
                this.buf.get(tmpBuf, 0, dataLen);
                return new IgniteBiTuple<String, byte[]>(key, tmpBuf.length > dataLen ? Arrays.copyOf(tmpBuf, dataLen) : tmpBuf);
            }).limit(this.size);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static interface TmpStorageInternal
    extends Closeable {
        public boolean add(String var1, byte[] var2) throws IOException;

        public Stream<IgniteBiTuple<String, byte[]>> stream() throws IOException;
    }
}

