/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheLocalConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntryFactory;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCachePreloaderAdapter;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.local.GridLocalCacheEntry;
import org.apache.ignite.internal.processors.cache.local.GridLocalLockFuture;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridLocalCache<K, V>
extends GridCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;
    private GridCachePreloader preldr;

    public GridLocalCache() {
    }

    public GridLocalCache(GridCacheContext<K, V> ctx) {
        super(ctx);
        this.preldr = new GridCachePreloaderAdapter(ctx.group());
    }

    @Override
    public void start() throws IgniteCheckedException {
        if (this.map == null) {
            this.map = new GridCacheLocalConcurrentMap(this.ctx, this.entryFactory(), DFLT_START_CACHE_SIZE);
        }
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public GridCachePreloader preloader() {
        return this.preldr;
    }

    private GridCacheMapEntryFactory entryFactory() {
        return new GridCacheMapEntryFactory(){

            @Override
            public GridCacheMapEntry create(GridCacheContext ctx, AffinityTopologyVersion topVer, KeyCacheObject key) {
                return new GridLocalCacheEntry(ctx, key);
            }
        };
    }

    @Nullable
    private GridLocalCacheEntry peekExx(KeyCacheObject key) {
        return (GridLocalCacheEntry)this.peekEx(key);
    }

    GridLocalCacheEntry entryExx(KeyCacheObject key) {
        return (GridLocalCacheEntry)this.entryEx(key);
    }

    @Override
    public IgniteInternalFuture<Boolean> txLockAsync(Collection<KeyCacheObject> keys, long timeout, IgniteTxLocalEx tx, boolean isRead, boolean retval, TransactionIsolation isolation, boolean invalidate, long createTtl, long accessTtl) {
        return this.lockAllAsync(keys, timeout, tx, CU.empty0());
    }

    @Override
    public IgniteInternalFuture<Boolean> lockAllAsync(Collection<? extends K> keys, long timeout) {
        IgniteTxLocalAdapter tx = this.ctx.tm().localTx();
        return this.lockAllAsync(this.ctx.cacheKeysView(keys), timeout, tx, CU.empty0());
    }

    public IgniteInternalFuture<Boolean> lockAllAsync(Collection<KeyCacheObject> keys, long timeout, @Nullable IgniteTxLocalEx tx, CacheEntryPredicate[] filter) {
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture<Boolean>(true);
        }
        GridLocalLockFuture fut = new GridLocalLockFuture(this.ctx, keys, tx, this, timeout, filter);
        try {
            if (!fut.addEntries(keys)) {
                return fut;
            }
            if (!this.ctx.mvcc().addFuture(fut)) {
                fut.onError(new IgniteCheckedException("Duplicate future ID (internal error): " + fut));
            }
            fut.checkLocks();
            return fut;
        }
        catch (IgniteCheckedException e) {
            fut.onError(e);
            return fut;
        }
    }

    @Override
    public void unlockAll(Collection<? extends K> keys) throws IgniteCheckedException {
        AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
        for (K key : keys) {
            GridLocalCacheEntry entry = this.peekExx(this.ctx.toCacheKeyObject(key));
            if (entry == null || !this.ctx.isAll(entry, CU.empty0())) continue;
            entry.releaseLocal();
            entry.touch();
        }
    }

    @Override
    public IgniteInternalFuture<?> removeAllAsync() {
        return this.ctx.closures().callLocalSafe(new GridPlainCallable<Void>(){

            @Override
            public Void call() throws Exception {
                GridLocalCache.this.removeAll();
                return null;
            }
        });
    }

    @Override
    public void onDeferredDelete(GridCacheEntryEx entry, GridCacheVersion ver) {
        assert (false) : "Should not be called";
    }

    void onFutureDone(GridLocalLockFuture fut) {
        if (this.ctx.mvcc().removeVersionedFuture(fut) && this.log().isDebugEnabled()) {
            this.log().debug("Explicitly removed future from map of futures: " + fut);
        }
    }

    @Override
    public long localSizeLong(CachePeekMode[] peekModes) throws IgniteCheckedException {
        GridCacheAdapter.PeekModes modes = GridLocalCache.parsePeekModes(peekModes, true);
        modes.primary = true;
        modes.backup = true;
        if (modes.offheap) {
            return this.ctx.offheap().cacheEntriesCount(this.ctx.cacheId());
        }
        if (modes.heap) {
            return this.size();
        }
        return 0L;
    }

    @Override
    public long localSizeLong(int part, CachePeekMode[] peekModes) throws IgniteCheckedException {
        return this.localSizeLong(peekModes);
    }

    @Override
    public void preloadPartition(int part) throws IgniteCheckedException {
        this.ctx.offheap().preloadPartition(part);
    }

    @Override
    public IgniteInternalFuture<?> preloadPartitionAsync(final int part) throws IgniteCheckedException {
        return this.ctx.closures().callLocalSafe(new GridPlainCallable<Void>(){

            @Override
            public Void call() throws Exception {
                GridLocalCache.this.preloadPartition(part);
                return null;
            }
        });
    }

    @Override
    public boolean localPreloadPartition(int part) throws IgniteCheckedException {
        this.ctx.offheap().preloadPartition(part);
        return true;
    }

    @Override
    public GridCacheVersion nextVersion() {
        return this.ctx.versions().next(this.ctx.shared().kernalContext().discovery().topologyVersion());
    }
}

