/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.topology;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionsStateValidator {
    private static final IgniteProductVersion SIZES_VALIDATION_AVAILABLE_SINCE = IgniteProductVersion.fromString("2.5.0");
    private final GridCacheSharedContext<?, ?> cctx;

    public GridDhtPartitionsStateValidator(GridCacheSharedContext<?, ?> cctx) {
        this.cctx = cctx;
    }

    public void validatePartitionCountersAndSizes(GridDhtPartitionsExchangeFuture fut, GridDhtPartitionTopology top, Map<UUID, GridDhtPartitionsSingleMessage> messages) throws IgniteCheckedException {
        HashSet<UUID> ignoringNodes = new HashSet<UUID>();
        for (DiscoveryEvent evt : fut.events().events()) {
            if (evt.type() != 10) continue;
            ignoringNodes.add(evt.eventNode().id());
        }
        StringBuilder error = new StringBuilder();
        Map<Integer, Map<UUID, Long>> resUpdCnt = this.validatePartitionsUpdateCounters(top, messages, ignoringNodes);
        Map<Object, Object> resSize = Collections.emptyMap();
        for (UUID id : messages.keySet()) {
            ClusterNode node = this.cctx.discovery().node(id);
            if (node == null || node.version().compareTo(SIZES_VALIDATION_AVAILABLE_SINCE) >= 0) continue;
            ignoringNodes.add(id);
        }
        if (!this.cctx.cache().cacheGroup(top.groupId()).mvccEnabled()) {
            resSize = this.validatePartitionsSizes(top, messages, ignoringNodes);
        }
        AffinityTopologyVersion topVer = fut.context().events().topologyVersion();
        if (!resUpdCnt.isEmpty() && !resSize.isEmpty()) {
            error.append("Partitions cache size and update counters are inconsistent for ").append(this.fold(topVer, resUpdCnt, resSize));
        } else if (!resUpdCnt.isEmpty() && resSize.isEmpty()) {
            error.append("Partitions update counters are inconsistent for ").append(this.fold(topVer, resUpdCnt));
        } else if (resUpdCnt.isEmpty() && !resSize.isEmpty()) {
            error.append("Partitions cache sizes are inconsistent for ").append(this.fold(topVer, resSize));
        }
        if (error.length() > 0) {
            HashSet<Integer> parts = new HashSet<Integer>(resUpdCnt.keySet());
            parts.addAll(resSize.keySet());
            throw new IgniteCheckedException(error.toString());
        }
    }

    @Nullable
    private Set<Integer> shouldIgnore(GridDhtPartitionTopology top, UUID nodeId, CachePartitionPartialCountersMap countersMap, Map<Integer, Long> sizesMap) {
        HashSet<Integer> ignore = null;
        for (int i = 0; i < countersMap.size(); ++i) {
            int p = countersMap.partitionAt(i);
            if (top.partitionState(nodeId, p) != GridDhtPartitionState.OWNING) {
                if (ignore == null) {
                    ignore = new HashSet<Integer>();
                }
                ignore.add(p);
                continue;
            }
            long updateCounter = countersMap.updateCounterAt(i);
            long size = sizesMap.getOrDefault(p, 0L);
            if (updateCounter != 0L || size != 0L) continue;
            if (ignore == null) {
                ignore = new HashSet();
            }
            ignore.add(p);
        }
        return ignore;
    }

    public Map<Integer, Map<UUID, Long>> validatePartitionsUpdateCounters(GridDhtPartitionTopology top, Map<UUID, GridDhtPartitionsSingleMessage> messages, Set<UUID> ignoringNodes) {
        HashMap<Integer, Map<UUID, Long>> invalidPartitions = new HashMap<Integer, Map<UUID, Long>>();
        HashMap<Integer, Map.Entry<UUID, Long>> updateCountersAndNodesByPartitions = new HashMap<Integer, Map.Entry<UUID, Long>>();
        for (GridDhtLocalPartition part : top.currentLocalPartitions()) {
            if (part.state() != GridDhtPartitionState.OWNING || part.updateCounter() == 0L && part.fullSize() == 0L) continue;
            updateCountersAndNodesByPartitions.put(part.id(), new AbstractMap.SimpleEntry<UUID, Long>(this.cctx.localNodeId(), part.updateCounter()));
        }
        int partitions = top.partitions();
        for (Map.Entry<UUID, GridDhtPartitionsSingleMessage> e : messages.entrySet()) {
            UUID nodeId = e.getKey();
            if (ignoringNodes.contains(nodeId)) continue;
            GridDhtPartitionsSingleMessage message = e.getValue();
            CachePartitionPartialCountersMap countersMap = message.partitionUpdateCounters(top.groupId(), partitions);
            Map<Integer, Long> sizesMap = message.partitionSizes(top.groupId());
            Set<Integer> ignorePartitions = this.shouldIgnore(top, nodeId, countersMap, sizesMap);
            for (int i = 0; i < countersMap.size(); ++i) {
                int p = countersMap.partitionAt(i);
                if (ignorePartitions != null && ignorePartitions.contains(p)) continue;
                long currentCounter = countersMap.updateCounterAt(i);
                this.process(invalidPartitions, updateCountersAndNodesByPartitions, p, nodeId, currentCounter);
            }
        }
        return invalidPartitions;
    }

    public Map<Integer, Map<UUID, Long>> validatePartitionsSizes(GridDhtPartitionTopology top, Map<UUID, GridDhtPartitionsSingleMessage> messages, Set<UUID> ignoringNodes) {
        HashMap<Integer, Map<UUID, Long>> invalidPartitions = new HashMap<Integer, Map<UUID, Long>>();
        HashMap<Integer, Map.Entry<UUID, Long>> sizesAndNodesByPartitions = new HashMap<Integer, Map.Entry<UUID, Long>>();
        for (GridDhtLocalPartition part : top.currentLocalPartitions()) {
            if (part.state() != GridDhtPartitionState.OWNING || part.updateCounter() == 0L && part.fullSize() == 0L) continue;
            sizesAndNodesByPartitions.put(part.id(), new AbstractMap.SimpleEntry<UUID, Long>(this.cctx.localNodeId(), part.fullSize()));
        }
        int partitions = top.partitions();
        for (Map.Entry<UUID, GridDhtPartitionsSingleMessage> e : messages.entrySet()) {
            UUID nodeId = e.getKey();
            if (ignoringNodes.contains(nodeId)) continue;
            GridDhtPartitionsSingleMessage message = e.getValue();
            CachePartitionPartialCountersMap countersMap = message.partitionUpdateCounters(top.groupId(), partitions);
            Map<Integer, Long> sizesMap = message.partitionSizes(top.groupId());
            Set<Integer> ignorePartitions = this.shouldIgnore(top, nodeId, countersMap, sizesMap);
            for (int i = 0; i < countersMap.size(); ++i) {
                int p = countersMap.partitionAt(i);
                if (ignorePartitions != null && ignorePartitions.contains(p)) continue;
                long currentSize = sizesMap.getOrDefault(p, 0L);
                this.process(invalidPartitions, sizesAndNodesByPartitions, p, nodeId, currentSize);
            }
        }
        return invalidPartitions;
    }

    private void process(Map<Integer, Map<UUID, Long>> invalidPartitions, Map<Integer, Map.Entry<UUID, Long>> countersAndNodes, int part, UUID node, long counter) {
        Map.Entry<UUID, Long> existingData = countersAndNodes.get(part);
        if (existingData == null) {
            countersAndNodes.put(part, new AbstractMap.SimpleEntry<UUID, Long>(node, counter));
        }
        if (existingData != null && counter != existingData.getValue()) {
            if (!invalidPartitions.containsKey(part)) {
                HashMap<UUID, Long> map = new HashMap<UUID, Long>();
                map.put(existingData.getKey(), existingData.getValue());
                invalidPartitions.put(part, map);
            }
            invalidPartitions.get(part).put(node, counter);
        }
    }

    private String fold(AffinityTopologyVersion topVer, Map<Integer, Map<UUID, Long>> invalidPartitions) {
        SB sb = new SB();
        TreeMap<Integer, Map<UUID, Long>> sortedPartitions = new TreeMap<Integer, Map<UUID, Long>>(invalidPartitions);
        for (Map.Entry p : sortedPartitions.entrySet()) {
            sb.a("Part ").a(p.getKey()).a(": [");
            for (Map.Entry e : ((Map)p.getValue()).entrySet()) {
                Object consistentId = this.cctx.discovery().node(topVer, (UUID)e.getKey()).consistentId();
                sb.a(consistentId).a("=").a(e.getValue()).a(" ");
            }
            sb.a("] ");
        }
        return sb.toString();
    }

    private String fold(AffinityTopologyVersion topVer, Map<Integer, Map<UUID, Long>> invalidPartitionsCounters, Map<Integer, Map<UUID, Long>> invalidPartitionsSize) {
        SB sb = new SB();
        TreeMap<Integer, HashMap<UUID, IgnitePair<Long>>> sortedAllPartitions = new TreeMap<Integer, HashMap<UUID, IgnitePair<Long>>>();
        HashSet<Integer> allKeys = new HashSet<Integer>(invalidPartitionsCounters.keySet());
        allKeys.addAll(invalidPartitionsSize.keySet());
        for (Integer n : allKeys) {
            HashMap<UUID, IgnitePair<Long>> map = new HashMap<UUID, IgnitePair<Long>>();
            this.fillMapForPartition(invalidPartitionsCounters.get(n), map, true);
            this.fillMapForPartition(invalidPartitionsSize.get(n), map, false);
            sortedAllPartitions.put(n, map);
        }
        for (Map.Entry entry : sortedAllPartitions.entrySet()) {
            sb.a("Part ").a(entry.getKey()).a(": [");
            for (Map.Entry e : ((Map)entry.getValue()).entrySet()) {
                Object consistentId = this.cctx.discovery().node(topVer, (UUID)e.getKey()).consistentId();
                sb.a("consistentId=").a(consistentId).a(" meta=[updCnt=").a(((IgnitePair)e.getValue()).get1()).a(", size=").a(((IgnitePair)e.getValue()).get2()).a("] ");
            }
            sb.a("] ");
        }
        return sb.toString();
    }

    private void fillMapForPartition(Map<UUID, Long> srcMap, Map<UUID, IgnitePair<Long>> resultMap, boolean isFirst) {
        if (srcMap != null) {
            srcMap.forEach((uuid, val) -> {
                IgnitePair pair = resultMap.computeIfAbsent((UUID)uuid, u -> new IgnitePair());
                if (isFirst) {
                    pair.set1(val);
                } else {
                    pair.set2(val);
                }
            });
        }
    }
}

