/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cluster.ClusterNode;

public class LocalAffinityFunction
implements AffinityFunction {
    private static final long serialVersionUID = 0L;

    @Override
    public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext affCtx) {
        ClusterNode locNode = null;
        for (ClusterNode n : affCtx.currentTopologySnapshot()) {
            if (!n.isLocal()) continue;
            locNode = n;
            break;
        }
        if (locNode == null) {
            throw new IgniteException("Local node is not included into affinity nodes for 'LOCAL' cache");
        }
        ArrayList<List<ClusterNode>> res = new ArrayList<List<ClusterNode>>(this.partitions());
        for (int part = 0; part < this.partitions(); ++part) {
            res.add(Collections.singletonList(locNode));
        }
        return Collections.unmodifiableList(res);
    }

    @Override
    public void reset() {
    }

    @Override
    public int partitions() {
        return 1;
    }

    @Override
    public int partition(Object key) {
        return 0;
    }

    @Override
    public void removeNode(UUID nodeId) {
    }
}

