/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.direct.stream.v3;

import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.direct.stream.v2.DirectByteBufferStreamImplV2;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class DirectByteBufferStreamImplV3
extends DirectByteBufferStreamImplV2 {
    private byte topVerState;
    private long topVerMajor;
    private int topVerMinor;

    public DirectByteBufferStreamImplV3(MessageFactory msgFactory) {
        super(msgFactory);
    }

    @Override
    public void writeAffinityTopologyVersion(AffinityTopologyVersion val) {
        if (val != null) {
            switch (this.topVerState) {
                case 0: {
                    this.writeInt(val.minorTopologyVersion());
                    if (!this.lastFinished) {
                        return;
                    }
                    this.topVerState = (byte)(this.topVerState + 1);
                }
                case 1: {
                    this.writeLong(val.topologyVersion());
                    if (!this.lastFinished) {
                        return;
                    }
                    this.topVerState = 0;
                }
            }
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public AffinityTopologyVersion readAffinityTopologyVersion() {
        switch (this.topVerState) {
            case 0: {
                this.topVerMinor = this.readInt();
                if (!this.lastFinished || this.topVerMinor == -1) {
                    return null;
                }
                this.topVerState = (byte)(this.topVerState + 1);
            }
            case 1: {
                this.topVerMajor = this.readLong();
                if (!this.lastFinished) {
                    return null;
                }
                this.topVerState = 0;
            }
        }
        return new AffinityTopologyVersion(this.topVerMajor, this.topVerMinor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(MessageCollectionItemType type, Object val, MessageWriter writer) {
        switch (type) {
            case BYTE: {
                this.writeByte((Byte)val);
                break;
            }
            case SHORT: {
                this.writeShort((Short)val);
                break;
            }
            case INT: {
                this.writeInt((Integer)val);
                break;
            }
            case LONG: {
                this.writeLong((Long)val);
                break;
            }
            case FLOAT: {
                this.writeFloat(((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                this.writeDouble((Double)val);
                break;
            }
            case CHAR: {
                this.writeChar(((Character)val).charValue());
                break;
            }
            case BOOLEAN: {
                this.writeBoolean((Boolean)val);
                break;
            }
            case BYTE_ARR: {
                this.writeByteArray((byte[])val);
                break;
            }
            case SHORT_ARR: {
                this.writeShortArray((short[])val);
                break;
            }
            case INT_ARR: {
                this.writeIntArray((int[])val);
                break;
            }
            case LONG_ARR: {
                this.writeLongArray((long[])val);
                break;
            }
            case FLOAT_ARR: {
                this.writeFloatArray((float[])val);
                break;
            }
            case DOUBLE_ARR: {
                this.writeDoubleArray((double[])val);
                break;
            }
            case CHAR_ARR: {
                this.writeCharArray((char[])val);
                break;
            }
            case BOOLEAN_ARR: {
                this.writeBooleanArray((boolean[])val);
                break;
            }
            case STRING: {
                this.writeString((String)val);
                break;
            }
            case BIT_SET: {
                this.writeBitSet((BitSet)val);
                break;
            }
            case UUID: {
                this.writeUuid((UUID)val);
                break;
            }
            case IGNITE_UUID: {
                this.writeIgniteUuid((IgniteUuid)val);
                break;
            }
            case AFFINITY_TOPOLOGY_VERSION: {
                this.writeAffinityTopologyVersion((AffinityTopologyVersion)val);
                break;
            }
            case MSG: {
                try {
                    if (val != null) {
                        writer.beforeInnerMessageWrite();
                    }
                    this.writeMessage((Message)val, writer);
                    break;
                }
                finally {
                    if (val != null) {
                        writer.afterInnerMessageWrite(this.lastFinished);
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
            }
        }
    }

    @Override
    protected Object read(MessageCollectionItemType type, MessageReader reader) {
        switch (type) {
            case BYTE: {
                return this.readByte();
            }
            case SHORT: {
                return this.readShort();
            }
            case INT: {
                return this.readInt();
            }
            case LONG: {
                return this.readLong();
            }
            case FLOAT: {
                return Float.valueOf(this.readFloat());
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case CHAR: {
                return Character.valueOf(this.readChar());
            }
            case BOOLEAN: {
                return this.readBoolean();
            }
            case BYTE_ARR: {
                return this.readByteArray();
            }
            case SHORT_ARR: {
                return this.readShortArray();
            }
            case INT_ARR: {
                return this.readIntArray();
            }
            case LONG_ARR: {
                return this.readLongArray();
            }
            case FLOAT_ARR: {
                return this.readFloatArray();
            }
            case DOUBLE_ARR: {
                return this.readDoubleArray();
            }
            case CHAR_ARR: {
                return this.readCharArray();
            }
            case BOOLEAN_ARR: {
                return this.readBooleanArray();
            }
            case STRING: {
                return this.readString();
            }
            case BIT_SET: {
                return this.readBitSet();
            }
            case UUID: {
                return this.readUuid();
            }
            case IGNITE_UUID: {
                return this.readIgniteUuid();
            }
            case AFFINITY_TOPOLOGY_VERSION: {
                return this.readAffinityTopologyVersion();
            }
            case MSG: {
                return this.readMessage(reader);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
    }
}

