/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.client.ClientAuthenticationException;
import org.apache.ignite.client.ClientAuthorizationException;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientFeatureNotSupportedByServerException;
import org.apache.ignite.client.ClientReconnectedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryCachingMetadataHandler;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryByteBufferInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientChannelConfiguration;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.internal.client.thin.ClientNotificationType;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.ClientServerError;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.NotificationListener;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.thin.ProtocolContext;
import org.apache.ignite.internal.client.thin.ProtocolVersion;
import org.apache.ignite.internal.client.thin.ProtocolVersionFeature;
import org.apache.ignite.internal.client.thin.io.ClientConnection;
import org.apache.ignite.internal.client.thin.io.ClientConnectionMultiplexer;
import org.apache.ignite.internal.client.thin.io.ClientConnectionStateHandler;
import org.apache.ignite.internal.client.thin.io.ClientMessageHandler;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

class TcpClientChannel
implements ClientChannel,
ClientMessageHandler,
ClientConnectionStateHandler {
    private static final ProtocolVersion DEFAULT_VERSION = ProtocolVersion.LATEST_VER;
    private static final Collection<ProtocolVersion> supportedVers = Arrays.asList(ProtocolVersion.V1_7_0, ProtocolVersion.V1_6_0, ProtocolVersion.V1_5_0, ProtocolVersion.V1_4_0, ProtocolVersion.V1_3_0, ProtocolVersion.V1_2_0, ProtocolVersion.V1_1_0, ProtocolVersion.V1_0_0);
    public static final byte[] EMPTY_BYTES = new byte[0];
    private volatile ProtocolContext protocolCtx;
    private volatile UUID srvNodeId;
    private volatile AffinityTopologyVersion srvTopVer;
    private final ClientConnection sock;
    private final AtomicLong reqId = new AtomicLong(1L);
    private final Map<Long, ClientRequestFuture> pendingReqs = new ConcurrentHashMap<Long, ClientRequestFuture>();
    private final Collection<Consumer<ClientChannel>> topChangeLsnrs = new CopyOnWriteArrayList<Consumer<ClientChannel>>();
    private final Map<Long, NotificationListener>[] notificationLsnrs = new Map[ClientNotificationType.values().length];
    private final Map<Long, Queue<T2<ByteBuffer, Exception>>>[] pendingNotifications = new Map[ClientNotificationType.values().length];
    private final ReadWriteLock notificationLsnrsGuard = new ReentrantReadWriteLock();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Executor asyncContinuationExecutor;
    private final int timeout;

    TcpClientChannel(ClientChannelConfiguration cfg, ClientConnectionMultiplexer connMgr) throws ClientConnectionException, ClientAuthenticationException, ClientProtocolError {
        TcpClientChannel.validateConfiguration(cfg);
        for (ClientNotificationType type : ClientNotificationType.values()) {
            if (!type.keepNotificationsWithoutListener()) continue;
            this.pendingNotifications[type.ordinal()] = new ConcurrentHashMap<Long, Queue<T2<ByteBuffer, Exception>>>();
        }
        Executor cfgExec = cfg.getAsyncContinuationExecutor();
        this.asyncContinuationExecutor = cfgExec != null ? cfgExec : ForkJoinPool.commonPool();
        this.timeout = cfg.getTimeout();
        this.sock = connMgr.open(cfg.getAddress(), this, this);
        this.handshake(DEFAULT_VERSION, cfg.getUserName(), cfg.getUserPassword(), cfg.getUserAttributes());
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void onMessage(ByteBuffer buf) {
        this.processNextMessage(buf);
    }

    @Override
    public void onDisconnected(@Nullable Exception e) {
        this.close(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Exception cause) {
        if (this.closed.compareAndSet(false, true)) {
            U.closeQuiet(this.sock);
            for (ClientRequestFuture pendingReq : this.pendingReqs.values()) {
                pendingReq.onDone(new ClientConnectionException("Channel is closed", cause));
            }
            this.notificationLsnrsGuard.readLock().lock();
            try {
                for (Map<Long, NotificationListener> lsnrs : this.notificationLsnrs) {
                    if (lsnrs == null) continue;
                    lsnrs.values().forEach(lsnr -> lsnr.onChannelClosed(cause));
                }
            }
            finally {
                this.notificationLsnrsGuard.readLock().unlock();
            }
        }
    }

    @Override
    public <T> T service(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientException {
        ClientRequestFuture fut = this.send(op, payloadWriter);
        return this.receive(fut, payloadReader);
    }

    @Override
    public <T> CompletableFuture<T> serviceAsync(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) {
        try {
            ClientRequestFuture fut = this.send(op, payloadWriter);
            return this.receiveAsync(fut, payloadReader);
        }
        catch (Throwable t) {
            CompletableFuture fut = new CompletableFuture();
            fut.completeExceptionally(t);
            return fut;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClientRequestFuture send(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter) throws ClientException {
        long id = this.reqId.getAndIncrement();
        try (PayloadOutputChannel payloadCh = new PayloadOutputChannel(this);){
            if (this.closed()) {
                throw new ClientConnectionException("Channel is closed");
            }
            ClientRequestFuture fut = new ClientRequestFuture();
            this.pendingReqs.put(id, fut);
            BinaryOutputStream req = payloadCh.out();
            req.writeInt(0);
            req.writeShort(op.code());
            req.writeLong(id);
            if (payloadWriter != null) {
                payloadWriter.accept(payloadCh);
            }
            req.writeInt(0, req.position() - 4);
            this.write(req.arrayCopy(), req.position());
            ClientRequestFuture clientRequestFuture = fut;
            return clientRequestFuture;
        }
        catch (Throwable t) {
            this.pendingReqs.remove(id);
            throw t;
        }
    }

    private <T> T receive(ClientRequestFuture pendingReq, Function<PayloadInputChannel, T> payloadReader) throws ClientException {
        try {
            ByteBuffer payload;
            ByteBuffer byteBuffer = payload = this.timeout > 0 ? (ByteBuffer)pendingReq.get(this.timeout) : (ByteBuffer)pendingReq.get();
            if (payload == null || payloadReader == null) {
                return null;
            }
            return payloadReader.apply(new PayloadInputChannel(this, payload));
        }
        catch (IgniteCheckedException e) {
            throw this.convertException(e);
        }
    }

    private <T> CompletableFuture<T> receiveAsync(ClientRequestFuture pendingReq, Function<PayloadInputChannel, T> payloadReader) {
        CompletableFuture fut = new CompletableFuture();
        pendingReq.listen(payloadFut -> this.asyncContinuationExecutor.execute(() -> {
            try {
                ByteBuffer payload = (ByteBuffer)payloadFut.get();
                if (payload == null || payloadReader == null) {
                    fut.complete(null);
                } else {
                    Object res = payloadReader.apply(new PayloadInputChannel(this, payload));
                    fut.complete(res);
                }
            }
            catch (Throwable t) {
                fut.completeExceptionally(this.convertException(t));
            }
        }));
        return fut;
    }

    private RuntimeException convertException(Throwable e) {
        if (e.getCause() instanceof ClientError) {
            return new ClientException(e.getMessage(), e.getCause());
        }
        if (e.getCause() instanceof ClientConnectionException) {
            return new ClientConnectionException(e.getMessage(), e.getCause());
        }
        if (e.getCause() instanceof ClientReconnectedException) {
            return new ClientReconnectedException(e.getMessage(), e.getCause());
        }
        if (e.getCause() instanceof ClientAuthenticationException) {
            return new ClientAuthenticationException(e.getMessage(), e.getCause());
        }
        if (e.getCause() instanceof ClientAuthorizationException) {
            return new ClientAuthorizationException(e.getMessage(), e.getCause());
        }
        if (e.getCause() instanceof ClientFeatureNotSupportedByServerException) {
            return new ClientFeatureNotSupportedByServerException(e.getMessage(), e.getCause());
        }
        if (e.getCause() instanceof ClientException) {
            return new ClientException(e.getMessage(), e.getCause());
        }
        return new ClientException(e.getMessage(), e);
    }

    private void processNextMessage(ByteBuffer buf) throws ClientProtocolError, ClientConnectionException {
        ByteBuffer res;
        RuntimeException err;
        BinaryByteBufferInputStream dataInput = BinaryByteBufferInputStream.create(buf);
        if (this.protocolCtx == null) {
            this.pendingReqs.remove(-1L).onDone(buf);
            return;
        }
        Long resId = dataInput.readLong();
        int status = 0;
        ClientOperation notificationOp = null;
        if (this.protocolCtx.isFeatureSupported(ProtocolVersionFeature.PARTITION_AWARENESS)) {
            short notificationCode;
            short flags = dataInput.readShort();
            if ((flags & 2) != 0) {
                long topVer = dataInput.readLong();
                int minorTopVer = dataInput.readInt();
                this.srvTopVer = new AffinityTopologyVersion(topVer, minorTopVer);
                for (Consumer<ClientChannel> lsnr : this.topChangeLsnrs) {
                    lsnr.accept(this);
                }
            }
            if ((flags & 4) != 0 && ((notificationOp = ClientOperation.fromCode(notificationCode = dataInput.readShort())) == null || notificationOp.notificationType() == null)) {
                throw new ClientProtocolError(String.format("Unexpected notification code [%d]", notificationCode));
            }
            if ((flags & 1) != 0) {
                status = dataInput.readInt();
            }
        } else {
            status = dataInput.readInt();
        }
        int hdrSize = dataInput.position();
        int msgSize = buf.limit();
        if (status == 0) {
            err = null;
            res = msgSize > hdrSize ? buf : null;
        } else if (status == 1012) {
            err = new ClientAuthorizationException();
            res = null;
        } else {
            String errMsg = ClientUtils.createBinaryReader(null, dataInput).readString();
            err = new ClientServerError(errMsg, status, resId);
            res = null;
        }
        if (notificationOp == null) {
            ClientRequestFuture pendingReq = this.pendingReqs.remove(resId);
            if (pendingReq == null) {
                throw new ClientProtocolError(String.format("Unexpected response ID [%s]", resId));
            }
            pendingReq.onDone(res, err);
        } else {
            ClientNotificationType notificationType = notificationOp.notificationType();
            this.asyncContinuationExecutor.execute(() -> {
                NotificationListener lsnr = null;
                this.notificationLsnrsGuard.readLock().lock();
                try {
                    Map<Long, NotificationListener> lsrns = this.notificationLsnrs[notificationType.ordinal()];
                    if (lsrns != null) {
                        lsnr = lsrns.get(resId);
                    }
                    if (notificationType.keepNotificationsWithoutListener() && lsnr == null) {
                        this.pendingNotifications[notificationType.ordinal()].computeIfAbsent(resId, k -> new ConcurrentLinkedQueue()).add(new T2<ByteBuffer, Exception>(res, err));
                    }
                }
                finally {
                    this.notificationLsnrsGuard.readLock().unlock();
                }
                if (lsnr != null) {
                    lsnr.acceptNotification(res, err);
                }
            });
        }
    }

    @Override
    public ProtocolContext protocolCtx() {
        return this.protocolCtx;
    }

    @Override
    public UUID serverNodeId() {
        return this.srvNodeId;
    }

    @Override
    public AffinityTopologyVersion serverTopologyVersion() {
        return this.srvTopVer;
    }

    @Override
    public void addTopologyChangeListener(Consumer<ClientChannel> lsnr) {
        this.topChangeLsnrs.add(lsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(ClientNotificationType type, Long rsrcId, NotificationListener lsnr) {
        Queue<T2<ByteBuffer, Exception>> pendingQueue = null;
        this.notificationLsnrsGuard.writeLock().lock();
        try {
            if (this.closed()) {
                throw new ClientConnectionException("Channel is closed");
            }
            Map<Long, NotificationListener> lsnrs = this.notificationLsnrs[type.ordinal()];
            if (lsnrs == null) {
                this.notificationLsnrs[type.ordinal()] = lsnrs = new ConcurrentHashMap<Long, NotificationListener>();
            }
            lsnrs.put(rsrcId, lsnr);
            if (type.keepNotificationsWithoutListener()) {
                pendingQueue = this.pendingNotifications[type.ordinal()].remove(rsrcId);
            }
        }
        finally {
            this.notificationLsnrsGuard.writeLock().unlock();
        }
        if (pendingQueue != null) {
            pendingQueue.forEach(n -> lsnr.acceptNotification((ByteBuffer)n.get1(), (Exception)n.get2()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(ClientNotificationType type, Long rsrcId) {
        this.notificationLsnrsGuard.writeLock().lock();
        try {
            Map<Long, NotificationListener> lsnrs = this.notificationLsnrs[type.ordinal()];
            if (lsnrs == null) {
                return;
            }
            lsnrs.remove(rsrcId);
            if (type.keepNotificationsWithoutListener()) {
                this.pendingNotifications[type.ordinal()].remove(rsrcId);
            }
        }
        finally {
            this.notificationLsnrsGuard.writeLock().unlock();
        }
    }

    @Override
    public boolean closed() {
        return this.closed.get();
    }

    private static void validateConfiguration(ClientChannelConfiguration cfg) {
        String error = null;
        InetSocketAddress addr = cfg.getAddress();
        if (addr == null) {
            error = "At least one Ignite server node must be specified in the Ignite client configuration";
        } else if (addr.getPort() < 1024 || addr.getPort() > 49151) {
            error = String.format("Ignite client port %s is out of valid ports range 1024...49151", addr.getPort());
        }
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    private void handshake(ProtocolVersion ver, String user, String pwd, Map<String, String> userAttrs) throws ClientConnectionException, ClientAuthenticationException, ClientProtocolError {
        ClientRequestFuture fut = new ClientRequestFuture();
        this.pendingReqs.put(-1L, fut);
        this.handshakeReq(ver, user, pwd, userAttrs);
        try {
            ByteBuffer res = this.timeout > 0 ? (ByteBuffer)fut.get(this.timeout) : (ByteBuffer)fut.get();
            this.handshakeRes(res, ver, user, pwd, userAttrs);
        }
        catch (IgniteCheckedException e) {
            throw new ClientConnectionException(e.getMessage(), e);
        }
    }

    private void handshakeReq(ProtocolVersion proposedVer, String user, String pwd, Map<String, String> userAttrs) throws ClientConnectionException {
        BinaryContext ctx = new BinaryContext(BinaryCachingMetadataHandler.create(), new IgniteConfiguration(), null);
        try (BinaryWriterExImpl writer = new BinaryWriterExImpl(ctx, new BinaryHeapOutputStream(32), null, null);){
            boolean authSupported;
            ProtocolContext protocolCtx = this.protocolContextFromVersion(proposedVer);
            writer.writeInt(0);
            writer.writeByte((byte)1);
            writer.writeShort(proposedVer.major());
            writer.writeShort(proposedVer.minor());
            writer.writeShort(proposedVer.patch());
            writer.writeByte((byte)2);
            if (protocolCtx.isFeatureSupported(ProtocolVersionFeature.BITMAP_FEATURES)) {
                byte[] features = ProtocolBitmaskFeature.featuresAsBytes(protocolCtx.features());
                writer.writeByteArray(features);
            }
            if (protocolCtx.isFeatureSupported(ProtocolBitmaskFeature.USER_ATTRIBUTES)) {
                writer.writeMap(userAttrs);
            }
            if ((authSupported = protocolCtx.isFeatureSupported(ProtocolVersionFeature.AUTHORIZATION)) && user != null && !user.isEmpty()) {
                writer.writeString(user);
                writer.writeString(pwd);
            }
            writer.out().writeInt(0, writer.out().position() - 4);
            this.write(writer.out().arrayCopy(), writer.out().position());
        }
    }

    private ProtocolContext protocolContextFromVersion(ProtocolVersion ver) {
        EnumSet<ProtocolBitmaskFeature> features = null;
        if (ProtocolContext.isFeatureSupported(ver, ProtocolVersionFeature.BITMAP_FEATURES)) {
            features = ProtocolBitmaskFeature.allFeaturesAsEnumSet();
        }
        return new ProtocolContext(ver, features);
    }

    private void handshakeRes(ByteBuffer buf, ProtocolVersion proposedVer, String user, String pwd, Map<String, String> userAttrs) throws ClientConnectionException, ClientAuthenticationException, ClientProtocolError {
        BinaryByteBufferInputStream res = BinaryByteBufferInputStream.create(buf);
        try (BinaryReaderExImpl reader = ClientUtils.createBinaryReader(null, res);){
            boolean success = res.readBoolean();
            if (success) {
                byte[] features = EMPTY_BYTES;
                if (ProtocolContext.isFeatureSupported(proposedVer, ProtocolVersionFeature.BITMAP_FEATURES)) {
                    features = reader.readByteArray();
                }
                this.protocolCtx = new ProtocolContext(proposedVer, ProtocolBitmaskFeature.enumSet(features));
                if (this.protocolCtx.isFeatureSupported(ProtocolVersionFeature.PARTITION_AWARENESS)) {
                    this.srvNodeId = reader.readUuid();
                }
            } else {
                ProtocolVersion srvVer = new ProtocolVersion(res.readShort(), res.readShort(), res.readShort());
                String err = reader.readString();
                int errCode = 1;
                if (res.remaining() > 0) {
                    errCode = reader.readInt();
                }
                if (errCode == 2000) {
                    throw new ClientAuthenticationException(err);
                }
                if (proposedVer.equals(srvVer)) {
                    throw new ClientProtocolError(err);
                }
                if (!supportedVers.contains(srvVer) || !ProtocolContext.isFeatureSupported(srvVer, ProtocolVersionFeature.AUTHORIZATION) && !F.isEmpty(user)) {
                    throw new ClientProtocolError(String.format("Protocol version mismatch: client %s / server %s. Server details: %s", proposedVer, srvVer, err));
                }
                this.handshake(srvVer, user, pwd, userAttrs);
            }
        }
        catch (IOException e) {
            throw this.handleIOError(e);
        }
    }

    private void write(byte[] bytes, int len) throws ClientConnectionException {
        ByteBuffer buf = ByteBuffer.wrap(bytes, 0, len);
        try {
            this.sock.send(buf);
        }
        catch (IgniteCheckedException e) {
            throw new ClientConnectionException(e.getMessage(), e);
        }
    }

    private ClientException handleIOError(@Nullable IOException ex) {
        return this.handleIOError("sock=" + this.sock, ex);
    }

    private ClientException handleIOError(String chInfo, @Nullable IOException ex) {
        return new ClientConnectionException("Ignite cluster is unavailable [" + chInfo + ']', ex);
    }

    private static class ClientRequestFuture
    extends GridFutureAdapter<ByteBuffer> {
        private ClientRequestFuture() {
        }
    }
}

