/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

public final class BytesCompareUtils {
    public static int compareNotNullSigned(byte[] arr0, byte[] arr1) {
        if (arr0 == arr1) {
            return 0;
        }
        int commonLen = Math.min(arr0.length, arr1.length);
        for (int i = 0; i < commonLen; ++i) {
            byte b0 = arr0[i];
            byte b1 = arr1[i];
            if (b0 == b1) continue;
            return b0 > b1 ? 1 : -1;
        }
        return Integer.signum(arr0.length - arr1.length);
    }

    public static int compareNotNullUnsigned(byte[] arr0, byte[] arr1) {
        if (arr0 == arr1) {
            return 0;
        }
        int commonLen = Math.min(arr0.length, arr1.length);
        for (int i = 0; i < commonLen; ++i) {
            int unSignArr0 = arr0[i] & 0xFF;
            int unSignArr1 = arr1[i] & 0xFF;
            if (unSignArr0 == unSignArr1) continue;
            return unSignArr0 > unSignArr1 ? 1 : -1;
        }
        return Integer.signum(arr0.length - arr1.length);
    }
}

