/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cache.query.index.IndexName;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandlerFactory;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexTree;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.metric.IoStatisticsHolderIndex;
import org.apache.ignite.internal.metric.IoStatisticsType;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTask;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class DurableBackgroundCleanupIndexTreeTask
implements DurableBackgroundTask {
    private static final long serialVersionUID = 0L;
    private List<Long> rootPages;
    private volatile transient List<InlineIndexTree> trees;
    private String cacheGrpName;
    private final String cacheName;
    private String schemaName;
    private final String treeName;
    private final String idxName;
    private final String id;
    @Nullable
    private volatile transient IgniteLogger log;
    @Nullable
    private volatile transient GridWorker worker;

    public DurableBackgroundCleanupIndexTreeTask(List<Long> rootPages, List<InlineIndexTree> trees, String cacheGrpName, String cacheName, IndexName idxName, String treeName) {
        this.rootPages = rootPages;
        this.trees = trees;
        this.cacheGrpName = cacheGrpName;
        this.cacheName = cacheName;
        this.id = UUID.randomUUID().toString();
        this.idxName = idxName.idxName();
        this.schemaName = idxName.schemaName();
        this.treeName = treeName;
    }

    @Override
    public String name() {
        return "DROP_SQL_INDEX-" + this.schemaName + "." + this.idxName + "-" + this.id;
    }

    @Override
    public IgniteInternalFuture<DurableBackgroundTaskResult> executeAsync(final GridKernalContext ctx) {
        this.log = ctx.log(this.getClass());
        assert (this.worker == null);
        final GridFutureAdapter<DurableBackgroundTaskResult> fut = new GridFutureAdapter<DurableBackgroundTaskResult>();
        this.worker = new GridWorker(ctx.igniteInstanceName(), "async-durable-background-task-executor-" + this.name(), this.log){

            @Override
            protected void body() {
                try {
                    DurableBackgroundCleanupIndexTreeTask.this.execute(ctx);
                    DurableBackgroundCleanupIndexTreeTask.this.worker = null;
                    fut.onDone(DurableBackgroundTaskResult.complete(null));
                }
                catch (Throwable t) {
                    DurableBackgroundCleanupIndexTreeTask.this.worker = null;
                    fut.onDone(DurableBackgroundTaskResult.restart(t));
                }
            }
        };
        new IgniteThread(this.worker).start();
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(GridKernalContext ctx) {
        List<InlineIndexTree> trees0 = this.trees;
        if (trees0 == null) {
            trees0 = new ArrayList<InlineIndexTree>(this.rootPages.size());
            GridCacheContext cctx = ctx.cache().context().cacheContext(CU.cacheId(this.cacheName));
            int grpId = CU.cacheGroupId(this.cacheName, this.cacheGrpName);
            CacheGroupContext grpCtx = ctx.cache().cacheGroup(grpId);
            if (grpCtx == null) {
                return;
            }
            IgniteCacheOffheapManager offheap = grpCtx.offheap();
            if (this.treeName != null) {
                ctx.cache().context().database().checkpointReadLock();
                try {
                    int cacheId = CU.cacheId(this.cacheName);
                    for (int segment = 0; segment < this.rootPages.size(); ++segment) {
                        try {
                            RootPage rootPage = offheap.findRootPageForIndex(cacheId, this.treeName, segment);
                            if (rootPage == null || this.rootPages.get(segment).longValue() != rootPage.pageId().pageId()) continue;
                            offheap.dropRootPageForIndex(cacheId, this.treeName, segment);
                            continue;
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException(e);
                        }
                    }
                }
                finally {
                    ctx.cache().context().database().checkpointReadUnlock();
                }
            }
            IoStatisticsHolderIndex stats = new IoStatisticsHolderIndex(IoStatisticsType.SORTED_INDEX, cctx.name(), this.idxName, cctx.kernalContext().metric());
            PageMemory pageMem = grpCtx.dataRegion().pageMemory();
            for (int i = 0; i < this.rootPages.size(); ++i) {
                Long rootPage = this.rootPages.get(i);
                assert (rootPage != null);
                if (this.skipDeletedRoot(grpId, pageMem, rootPage)) {
                    ctx.log(this.getClass()).warning(S.toString("Skipping deletion of the index tree", "cacheGrpName", (Object)this.cacheGrpName, false, "cacheName", (Object)this.cacheName, false, "idxName", (Object)this.idxName, false, "segment", (Object)i, false, "rootPageId", (Object)PageIdUtils.toDetailString(rootPage), false));
                    continue;
                }
                try {
                    String treeName = "deletedTree_" + i + "_" + this.name();
                    InlineIndexTree tree = new InlineIndexTree(null, cctx, treeName, cctx.offheap(), cctx.offheap().reuseListForIndex(treeName), cctx.dataRegion().pageMemory(), PageIoResolver.DEFAULT_PAGE_IO_RESOLVER, rootPage, false, 0, new IndexKeyTypeSettings(), null, stats, new NoopRowHandlerFactory(), null);
                    trees0.add(tree);
                    continue;
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }
        }
        ctx.cache().context().database().checkpointReadLock();
        try {
            for (int i = 0; i < trees0.size(); ++i) {
                BPlusTree tree = trees0.get(i);
                try {
                    tree.destroy(null, true);
                    continue;
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }
        }
        finally {
            ctx.cache().context().database().checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean skipDeletedRoot(int grpId, PageMemory pageMem, long rootPageId) {
        try {
            long page = pageMem.acquirePage(grpId, rootPageId);
            try {
                boolean bl;
                block9: {
                    long pageAddr = pageMem.readLock(grpId, rootPageId, page);
                    try {
                        boolean bl2 = bl = pageAddr == 0L;
                        if (pageAddr == 0L) break block9;
                    }
                    catch (Throwable throwable) {
                        if (pageAddr != 0L) {
                            pageMem.readUnlock(grpId, rootPageId, page);
                        }
                        throw throwable;
                    }
                    pageMem.readUnlock(grpId, rootPageId, page);
                }
                return bl;
            }
            finally {
                pageMem.releasePage(grpId, rootPageId, page);
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Cannot acquire tree root page.", e);
        }
    }

    @Override
    public void cancel() {
        this.trees = null;
        GridWorker w = this.worker;
        if (w != null) {
            this.worker = null;
            U.awaitForWorkersStop(Collections.singleton(w), true, this.log);
        }
    }

    public String toString() {
        return S.toString(DurableBackgroundCleanupIndexTreeTask.class, this);
    }

    private static class NoopRowHandlerFactory
    implements InlineIndexRowHandlerFactory {
        private NoopRowHandlerFactory() {
        }

        @Override
        public InlineIndexRowHandler create(SortedIndexDefinition sdef, IndexKeyTypeSettings keyTypeSettings) {
            return new InlineIndexRowHandler(){

                @Override
                public IndexKey indexKey(int idx, CacheDataRow row) {
                    return null;
                }

                @Override
                public List<InlineIndexKeyType> inlineIndexKeyTypes() {
                    return Collections.emptyList();
                }

                @Override
                public List<IndexKeyDefinition> indexKeyDefinitions() {
                    return Collections.emptyList();
                }

                @Override
                public IndexKeyTypeSettings indexKeyTypeSettings() {
                    return null;
                }

                @Override
                public int partition(CacheDataRow row) {
                    return 0;
                }

                @Override
                public Object cacheKey(CacheDataRow row) {
                    return null;
                }

                @Override
                public Object cacheValue(CacheDataRow row) {
                    return null;
                }
            };
        }
    }
}

