/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.generators.standard;

import java.util.stream.Stream;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.util.generators.DataStreamGenerator;
import org.apache.ignite.ml.util.generators.primitives.scalar.GaussRandomProducer;
import org.apache.ignite.ml.util.generators.primitives.vector.VectorGeneratorPrimitives;
import org.apache.ignite.ml.util.generators.primitives.vector.VectorGeneratorsFamily;

public class RingsDataStream
implements DataStreamGenerator {
    private final int cntOfRings;
    private final double minRadius;
    private final double distanceBetweenRings;
    private long seed;

    public RingsDataStream(int cntOfRings, double minRadius, double distanceBetweenRings) {
        this(cntOfRings, minRadius, distanceBetweenRings, System.currentTimeMillis());
    }

    public RingsDataStream(int cntOfRings, double minRadius, double distanceBetweenRings, long seed) {
        A.ensure((cntOfRings > 0 ? 1 : 0) != 0, (String)"countOfRings > 0");
        A.ensure((minRadius > 0.0 ? 1 : 0) != 0, (String)"minRadius > 0");
        A.ensure((distanceBetweenRings > 0.0 ? 1 : 0) != 0, (String)"distanceBetweenRings > 0");
        this.cntOfRings = cntOfRings;
        this.minRadius = minRadius;
        this.distanceBetweenRings = distanceBetweenRings;
        this.seed = seed;
    }

    @Override
    public Stream<LabeledVector<Double>> labeled() {
        VectorGeneratorsFamily.Builder builder = new VectorGeneratorsFamily.Builder();
        for (int i = 0; i < this.cntOfRings; ++i) {
            double radius = this.minRadius + this.distanceBetweenRings * (double)i;
            double variance = 0.1 * (double)(i + 1);
            GaussRandomProducer gauss = new GaussRandomProducer(0.0, variance, this.seed);
            builder = builder.add(VectorGeneratorPrimitives.ring(radius, 0.0, Math.PI * 2).noisify(gauss));
            this.seed *= 2L;
        }
        return builder.build().asDataStream().labeled();
    }
}

