/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.randomforest.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.tree.randomforest.data.TreeNode;

public class RandomForestTreeModel
implements IgniteModel<Vector, Double> {
    private static final long serialVersionUID = 531797299171329057L;
    private TreeNode rootNode;
    private Set<Integer> usedFeatures;

    public RandomForestTreeModel(TreeNode root, Set<Integer> usedFeatures) {
        this.rootNode = root;
        this.usedFeatures = usedFeatures;
    }

    public RandomForestTreeModel() {
    }

    @Override
    public Double predict(Vector vector) {
        return this.rootNode.predict(vector);
    }

    public Set<Integer> getUsedFeatures() {
        return this.usedFeatures;
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public List<TreeNode> leafs() {
        ArrayList<TreeNode> res = new ArrayList<TreeNode>();
        this.leafs(this.rootNode, res);
        return res;
    }

    private void leafs(TreeNode root, List<TreeNode> res) {
        if (root.getType() == TreeNode.Type.LEAF) {
            res.add(root);
        } else {
            this.leafs(root.getLeft(), res);
            this.leafs(root.getRight(), res);
        }
    }

    public static String printTree(TreeNode node, boolean pretty) {
        StringBuilder builder = new StringBuilder();
        RandomForestTreeModel.printTree(node, 0, builder, pretty, false);
        return builder.toString();
    }

    private static void printTree(TreeNode node, int depth, StringBuilder builder, boolean pretty, boolean isThen) {
        builder.append(pretty ? String.join((CharSequence)"", Collections.nCopies(depth, "\t")) : "");
        if (node.getType() == TreeNode.Type.LEAF) {
            TreeNode leaf = node;
            builder.append(String.format("%s return ", isThen ? "then" : "else")).append(String.format("%.4f", leaf.getVal()));
        } else if (node.getType() == TreeNode.Type.CONDITIONAL) {
            TreeNode cond = node;
            String prefix = depth == 0 ? "" : (isThen ? "then " : "else ");
            builder.append(String.format("%sif (x", prefix)).append(cond.getFeatureId()).append(" > ").append(String.format("%.4f", cond.getVal())).append(pretty ? ")\n" : ") ");
            RandomForestTreeModel.printTree(cond.getLeft(), depth + 1, builder, pretty, true);
            builder.append(pretty ? "\n" : " ");
            RandomForestTreeModel.printTree(cond.getRight(), depth + 1, builder, pretty, false);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String toString(boolean pretty) {
        return RandomForestTreeModel.printTree(this.getRootNode(), pretty);
    }

    public String toString() {
        return RandomForestTreeModel.printTree(this.getRootNode(), false);
    }
}

