/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.leaf;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.tree.DecisionTreeLeafNode;
import org.apache.ignite.ml.tree.TreeFilter;
import org.apache.ignite.ml.tree.data.DecisionTreeData;
import org.apache.ignite.ml.tree.leaf.DecisionTreeLeafBuilder;

public class MostCommonDecisionTreeLeafBuilder
implements DecisionTreeLeafBuilder {
    @Override
    public DecisionTreeLeafNode createLeafNode(Dataset<EmptyContext, DecisionTreeData> dataset, TreeFilter pred) {
        Map cnt = (Map)dataset.compute(part -> {
            if (part.getFeatures() != null) {
                HashMap<Double, Integer> map = new HashMap<Double, Integer>();
                for (int i = 0; i < part.getFeatures().length; ++i) {
                    if (!pred.test(part.getFeatures()[i])) continue;
                    double lb = part.getLabels()[i];
                    if (map.containsKey(lb)) {
                        map.put(lb, (Integer)map.get(lb) + 1);
                        continue;
                    }
                    map.put(lb, 1);
                }
                return map;
            }
            return null;
        }, this::reduce);
        double bestVal = 0.0;
        int bestCnt = -1;
        for (Map.Entry e : cnt.entrySet()) {
            if ((Integer)e.getValue() <= bestCnt) continue;
            bestCnt = (Integer)e.getValue();
            bestVal = (Double)e.getKey();
        }
        return new DecisionTreeLeafNode(bestVal);
    }

    private Map<Double, Integer> reduce(Map<Double, Integer> a, Map<Double, Integer> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        for (Map.Entry<Double, Integer> e : b.entrySet()) {
            if (a.containsKey(e.getKey())) {
                a.put(e.getKey(), a.get(e.getKey()) + e.getValue());
                continue;
            }
            a.put(e.getKey(), e.getValue());
        }
        return a;
    }
}

