/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.AbstractVector;
import org.apache.ignite.ml.math.primitives.vector.NamedVector;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.impl.DelegatingNamedVector;
import org.apache.ignite.ml.math.primitives.vector.impl.DenseVector;
import org.apache.ignite.ml.math.primitives.vector.impl.SparseVector;

public class VectorUtils {
    public static Vector zeroesLike(Vector v) {
        return v.like(v.size()).assign(0.0);
    }

    public static DenseVector zeroes(int n) {
        return (DenseVector)new DenseVector(n).assign(0.0);
    }

    public static DenseVector fill(double val, int n) {
        return (DenseVector)new DenseVector(n).assign(val);
    }

    public static Vector num2Vec(double val) {
        return VectorUtils.fill(val, 1);
    }

    public static double[] num2Arr(double val) {
        return new double[]{val};
    }

    public static double vec2Num(Vector vec) {
        int max = 0;
        double maxVal = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < vec.size(); ++i) {
            double curVal = vec.getX(i);
            if (!(curVal > maxVal)) continue;
            max = i;
            maxVal = curVal;
        }
        return max;
    }

    public static Vector elementWiseTimes(Vector vec1, Vector vec2) {
        vec1.map(vec2, (a, b) -> a * b);
        return vec1;
    }

    public static Vector elementWiseMinus(Vector vec1, Vector vec2) {
        vec1.map(vec2, (a, b) -> a - b);
        return vec1;
    }

    public static Vector zipWith(Vector v1, Vector v2, IgniteBiFunction<Double, Double, Double> f) {
        int size = Math.min(v1.size(), v2.size());
        Vector res = v1.like(size);
        for (int row = 0; row < size; ++row) {
            res.setX(row, (Double)f.apply(v1.getX(row), v2.getX(row)));
        }
        return res;
    }

    public static Vector copyPart(Vector v, int off, int len) {
        assert (off >= 0);
        assert (len <= v.size());
        Vector res = v.like(len);
        for (int i = 0; i < len; ++i) {
            res.setX(i, v.getX(off + i));
        }
        return res;
    }

    public static Vector of(double ... values) {
        A.notNull((Object)values, (String)"values");
        return new DenseVector(values);
    }

    public static Vector of(Double[] values) {
        A.notNull((Object)values, (String)"values");
        AbstractVector answer = Arrays.stream(values).anyMatch(Objects::isNull) ? new SparseVector(values.length) : new DenseVector(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            answer.set(i, values[i]);
        }
        return answer;
    }

    public static NamedVector of(Map<String, Double> values) {
        SparseVector vector = new SparseVector(values.size());
        for (int i = 0; i < values.size(); ++i) {
            vector.set(i, Double.NaN);
        }
        HashMap<String, Integer> dict = new HashMap<String, Integer>();
        int idx = 0;
        for (Map.Entry<String, Double> e : values.entrySet()) {
            dict.put(e.getKey(), idx);
            vector.set(idx, e.getValue());
            ++idx;
        }
        return new DelegatingNamedVector(vector, dict);
    }

    public static Vector concat(Vector v1, Vector v2) {
        int size1 = v1.size();
        int size2 = v2.size();
        double[] vals = new double[size1 + size2];
        System.arraycopy(v1.asArray(), 0, vals, 0, size1);
        System.arraycopy(v2.asArray(), 0, vals, size1, size2);
        return new DenseVector(vals);
    }

    public static Vector concat(Vector v1, Vector ... vs) {
        Vector res = v1;
        for (Vector v : vs) {
            res = VectorUtils.concat(res, v);
        }
        return res;
    }

    public static Vector concat(Vector ... vs) {
        Vector res = vs.length == 0 ? new DenseVector() : vs[0];
        for (int i = 1; i < vs.length; ++i) {
            Vector v = vs[i];
            res = VectorUtils.concat(res, v);
        }
        return res;
    }

    public static IgniteFunction<Vector, Vector> getProjector(int[] mapping) {
        return v -> {
            DenseVector res = VectorUtils.zeroes(mapping.length);
            for (int i = 0; i < mapping.length; ++i) {
                res.set(i, v.get(mapping[i]));
            }
            return res;
        };
    }
}

