/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.distances;

import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.exceptions.math.CardinalityException;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class JensenShannonDistance
implements DistanceMeasure {
    private static final long serialVersionUID = 1771556549784040093L;
    private final Double base;

    public JensenShannonDistance() {
        this.base = Math.E;
    }

    public JensenShannonDistance(Double base) {
        this.base = base;
    }

    @Override
    public double compute(Vector a, Vector b) throws CardinalityException {
        Vector aNormalized = MatrixUtil.localCopyOf(a).divide(a.sum());
        Vector bNormalized = MatrixUtil.localCopyOf(b).divide(b.sum());
        Vector mean = aNormalized.plus(bNormalized).divide(2.0);
        double js = aNormalized.map(mean, this::relativeEntropy).sum() + bNormalized.map(mean, this::relativeEntropy).sum();
        return Math.sqrt((js /= Math.log(this.base)) / 2.0);
    }

    private double relativeEntropy(double x, double y) {
        if (x > 0.0 && y > 0.0) {
            return x * Math.log(x / y);
        }
        if (x == 0.0 && y >= 0.0) {
            return 0.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

