/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.primitive;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.primitive.FeatureMatrixWithLabelsOnHeapData;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.structures.LabeledVector;

public class FeatureMatrixWithLabelsOnHeapDataBuilder<K, V, C extends Serializable, CO extends Serializable>
implements PartitionDataBuilder<K, V, C, FeatureMatrixWithLabelsOnHeapData> {
    private static final long serialVersionUID = 6273736987424171813L;
    private final Preprocessor<K, V> preprocessor;

    public FeatureMatrixWithLabelsOnHeapDataBuilder(Preprocessor<K, V> preprocessor) {
        this.preprocessor = preprocessor;
    }

    @Override
    public FeatureMatrixWithLabelsOnHeapData build(LearningEnvironment env, Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        double[][] features = new double[Math.toIntExact(upstreamDataSize)][];
        double[] labels = new double[Math.toIntExact(upstreamDataSize)];
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            LabeledVector labeledVector = (LabeledVector)this.preprocessor.apply(entry.getKey(), entry.getValue());
            features[ptr] = labeledVector.features().asArray();
            labels[ptr] = (Double)labeledVector.label();
            ++ptr;
        }
        return new FeatureMatrixWithLabelsOnHeapData(features, labels);
    }
}

