/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.composition.boosting;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.composition.ModelsComposition;
import org.apache.ignite.ml.composition.predictionsaggregator.WeightedPredictionsAggregator;
import org.apache.ignite.ml.inference.json.JSONModelMixIn;
import org.apache.ignite.ml.inference.json.JSONWritable;
import org.apache.ignite.ml.inference.json.JacksonHelper;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.tree.DecisionTreeModel;

public final class GDBModel
extends ModelsComposition<DecisionTreeModel>
implements JSONWritable {
    private static final long serialVersionUID = 3476661240155508004L;
    @JsonIgnore
    private IgniteFunction<Double, Double> internalToExternalLblMapping;

    public GDBModel(List<? extends IgniteModel<Vector, Double>> models, WeightedPredictionsAggregator predictionsAggregator, IgniteFunction<Double, Double> internalToExternalLblMapping) {
        super(models, predictionsAggregator);
        this.internalToExternalLblMapping = internalToExternalLblMapping;
    }

    private GDBModel() {
    }

    public GDBModel withLblMapping(IgniteFunction<Double, Double> internalToExternalLblMapping) {
        this.internalToExternalLblMapping = internalToExternalLblMapping;
        return this;
    }

    @Override
    public Double predict(Vector features) {
        if (this.internalToExternalLblMapping == null) {
            throw new IllegalArgumentException("The mapping should not be empty. Initialize it with apropriate function. ");
        }
        return (Double)this.internalToExternalLblMapping.apply(super.predict(features));
    }

    @Override
    public void toJSON(Path path) {
        ObjectMapper mapper = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.addMixIn(GDBModel.class, JSONModelMixIn.class);
        ObjectWriter writer = mapper.writerFor(GDBModel.class).withAttribute((Object)"formatVersion", (Object)"1").withAttribute((Object)"timestamp", (Object)System.currentTimeMillis()).withAttribute((Object)"uid", (Object)("dt_" + UUID.randomUUID().toString())).withAttribute((Object)"modelClass", (Object)GDBModel.class.getSimpleName());
        try {
            File file = new File(path.toAbsolutePath().toString());
            writer.writeValue(file, (Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static GDBModel fromJSON(Path path) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            JacksonHelper.readAndValidateBasicJsonModelProperties(path, mapper, GDBModel.class.getSimpleName());
            GDBModel mdl = (GDBModel)mapper.readValue(new File(path.toAbsolutePath().toString()), GDBModel.class);
            return mdl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

