/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.result;

import com.mysql.cj.Messages;
import com.mysql.cj.WarningListener;
import com.mysql.cj.exceptions.DataReadException;
import com.mysql.cj.exceptions.ExceptionFactory;
import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.result.DefaultValueFactory;
import java.sql.Time;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class SqlTimeValueFactory
extends DefaultValueFactory<Time> {
    private WarningListener warningListener;
    private Calendar cal;

    public SqlTimeValueFactory(Calendar calendar, TimeZone tz) {
        if (calendar != null) {
            this.cal = (Calendar)calendar.clone();
        } else {
            this.cal = Calendar.getInstance(tz, Locale.US);
            this.cal.setLenient(false);
        }
    }

    public SqlTimeValueFactory(Calendar calendar, TimeZone tz, WarningListener warningListener) {
        this(calendar, tz);
        this.warningListener = warningListener;
    }

    @Override
    public Time createFromTime(int hours, int minutes, int seconds, int nanos) {
        if (hours < 0 || hours >= 24) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidTimeValue", new Object[]{"" + hours + ":" + minutes + ":" + seconds}));
        }
        Calendar calendar = this.cal;
        synchronized (calendar) {
            try {
                this.cal.set(1970, 0, 1, hours, minutes, seconds);
                this.cal.set(14, 0);
                long ms = (long)(nanos / 1000000) + this.cal.getTimeInMillis();
                return new Time(ms);
            }
            catch (IllegalArgumentException e) {
                throw ExceptionFactory.createException(WrongArgumentException.class, e.getMessage(), e);
            }
        }
    }

    @Override
    public Time createFromTimestamp(int year, int month, int day, int hours, int minutes, int seconds, int nanos) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{"java.sql.Time"}));
        }
        return this.createFromTime(hours, minutes, seconds, nanos);
    }

    @Override
    public String getTargetTypeName() {
        return Time.class.getName();
    }
}

